/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;
    private final String directory;

    public SimpleJsonResourceReloadListener(Gson $$0, String $$1) {
        this.gson = $$0;
        this.directory = $$1;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager $$0, ProfilerFiller $$1) {
        HashMap<ResourceLocation, JsonElement> $$2 = new HashMap<ResourceLocation, JsonElement>();
        SimpleJsonResourceReloadListener.scanDirectory($$0, this.directory, this.gson, $$2);
        return $$2;
    }

    public static void scanDirectory(ResourceManager $$0, String $$1, Gson $$2, Map<ResourceLocation, JsonElement> $$3) {
        FileToIdConverter $$4 = FileToIdConverter.json($$1);
        for (Map.Entry<ResourceLocation, Resource> $$5 : $$4.listMatchingResources($$0).entrySet()) {
            ResourceLocation $$6 = $$5.getKey();
            ResourceLocation $$7 = $$4.fileToId($$6);
            try {
                BufferedReader $$8 = $$5.getValue().openAsReader();
                try {
                    JsonElement $$9 = GsonHelper.fromJson($$2, (Reader)$$8, JsonElement.class);
                    JsonElement $$10 = $$3.put($$7, $$9);
                    if ($$10 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf($$7));
                }
                finally {
                    if ($$8 == null) continue;
                    ((Reader)$$8).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException $$11) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{$$7, $$6, $$11});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }
}

