/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownPotion
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = $$0 -> $$0.isSensitiveToWater() || $$0.isOnFire();

    public ThrownPotion(EntityType<? extends ThrownPotion> $$0, Level $$1) {
        super((EntityType<? extends ThrowableItemProjectile>)$$0, $$1);
    }

    public ThrownPotion(Level $$0, LivingEntity $$1) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.POTION, $$1, $$0);
    }

    public ThrownPotion(Level $$0, double $$1, double $$2, double $$3) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.POTION, $$1, $$2, $$3, $$0);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult $$0) {
        super.onHitBlock($$0);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack $$1 = this.getItem();
        Direction $$2 = $$0.getDirection();
        BlockPos $$3 = $$0.getBlockPos();
        BlockPos $$4 = $$3.relative($$2);
        PotionContents $$5 = $$1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if ($$5.is(Potions.WATER)) {
            this.dowseFire($$4);
            this.dowseFire($$4.relative($$2.getOpposite()));
            for (Direction $$6 : Direction.Plane.HORIZONTAL) {
                this.dowseFire($$4.relative($$6));
            }
        }
    }

    @Override
    protected void onHit(HitResult $$0) {
        super.onHit($$0);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack $$1 = this.getItem();
        PotionContents $$2 = $$1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if ($$2.is(Potions.WATER)) {
            this.applyWater();
        } else if ($$2.hasEffects()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud($$2);
            } else {
                this.applySplash($$2.getAllEffects(), $$0.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)$$0).getEntity() : null);
            }
        }
        int $$3 = $$2.potion().isPresent() && $$2.potion().get().value().hasInstantEffects() ? 2007 : 2002;
        this.level().levelEvent($$3, this.blockPosition(), $$2.getColor());
        this.discard();
    }

    private void applyWater() {
        AABB $$0 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> $$1 = this.level().getEntitiesOfClass(LivingEntity.class, $$0, WATER_SENSITIVE_OR_ON_FIRE);
        for (LivingEntity $$2 : $$1) {
            double $$3 = this.distanceToSqr($$2);
            if (!($$3 < 16.0)) continue;
            if ($$2.isSensitiveToWater()) {
                $$2.hurt(this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!$$2.isOnFire() || !$$2.isAlive()) continue;
            $$2.extinguishFire();
        }
        List<Axolotl> $$4 = this.level().getEntitiesOfClass(Axolotl.class, $$0);
        for (Axolotl $$5 : $$4) {
            $$5.rehydrate();
        }
    }

    private void applySplash(Iterable<MobEffectInstance> $$0, @Nullable Entity $$12) {
        AABB $$2 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> $$3 = this.level().getEntitiesOfClass(LivingEntity.class, $$2);
        if (!$$3.isEmpty()) {
            Entity $$4 = this.getEffectSource();
            for (LivingEntity $$5 : $$3) {
                double $$8;
                double $$6;
                if (!$$5.isAffectedByPotions() || !(($$6 = this.distanceToSqr($$5)) < 16.0)) continue;
                if ($$5 == $$12) {
                    double $$7 = 1.0;
                } else {
                    $$8 = 1.0 - Math.sqrt($$6) / 4.0;
                }
                for (MobEffectInstance $$9 : $$0) {
                    Holder<MobEffect> $$10 = $$9.getEffect();
                    if ($$10.value().isInstantenous()) {
                        $$10.value().applyInstantenousEffect(this, this.getOwner(), $$5, $$9.getAmplifier(), $$8);
                        continue;
                    }
                    int $$11 = $$9.mapDuration($$1 -> (int)($$8 * (double)$$1 + 0.5));
                    MobEffectInstance $$122 = new MobEffectInstance($$10, $$11, $$9.getAmplifier(), $$9.isAmbient(), $$9.isVisible());
                    if ($$122.endsWithin(20)) continue;
                    $$5.addEffect($$122, $$4);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents $$0) {
        AreaEffectCloud $$1 = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)entity;
            $$1.setOwner($$2);
        }
        $$1.setRadius(3.0f);
        $$1.setRadiusOnUse(-0.5f);
        $$1.setWaitTime(10);
        $$1.setRadiusPerTick(-$$1.getRadius() / (float)$$1.getDuration());
        $$1.setPotionContents($$0);
        this.level().addFreshEntity($$1);
    }

    private boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPos $$0) {
        BlockState $$1 = this.level().getBlockState($$0);
        if ($$1.is(BlockTags.FIRE)) {
            this.level().destroyBlock($$0, false, this);
        } else if (AbstractCandleBlock.isLit($$1)) {
            AbstractCandleBlock.extinguish(null, $$1, this.level(), $$0);
        } else if (CampfireBlock.isLitCampfire($$1)) {
            this.level().levelEvent(null, 1009, $$0, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), $$0, $$1);
            this.level().setBlockAndUpdate($$0, (BlockState)$$1.setValue(CampfireBlock.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity $$0, DamageSource $$1) {
        double $$2 = $$0.position().x - this.position().x;
        double $$3 = $$0.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)$$2, (double)$$3);
    }
}

