/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class SmithingTransformRecipe
implements SmithingRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public SmithingTransformRecipe(Ingredient $$0, Ingredient $$1, Ingredient $$2, ItemStack $$3) {
        this.template = $$0;
        this.base = $$1;
        this.addition = $$2;
        this.result = $$3;
    }

    @Override
    public boolean matches(SmithingRecipeInput $$0, Level $$1) {
        return this.template.test($$0.template()) && this.base.test($$0.base()) && this.addition.test($$0.addition());
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput $$0, HolderLookup.Provider $$1) {
        ItemStack $$2 = $$0.base().transmuteCopy(this.result.getItem(), this.result.getCount());
        $$2.applyComponents(this.result.getComponentsPatch());
        return $$2;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider $$0) {
        return this.result;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack $$0) {
        return this.template.test($$0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack $$0) {
        return this.base.test($$0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack $$0) {
        return this.addition.test($$0);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(Ingredient::isEmpty);
    }

    public static class Serializer
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final MapCodec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)Ingredient.CODEC.fieldOf("template").forGetter($$0 -> $$0.template), (App)Ingredient.CODEC.fieldOf("base").forGetter($$0 -> $$0.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter($$0 -> $$0.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter($$0 -> $$0.result)).apply((Applicative)$$02, SmithingTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingTransformRecipe fromNetwork(RegistryFriendlyByteBuf $$0) {
            Ingredient $$1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
            Ingredient $$2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
            Ingredient $$3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
            ItemStack $$4 = (ItemStack)ItemStack.STREAM_CODEC.decode($$0);
            return new SmithingTransformRecipe($$1, $$2, $$3, $$4);
        }

        private static void toNetwork(RegistryFriendlyByteBuf $$0, SmithingTransformRecipe $$1) {
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1.addition);
            ItemStack.STREAM_CODEC.encode($$0, $$1.result);
        }
    }
}

