/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize(3, ItemStack.EMPTY);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    @Nullable
    private static volatile Map<Item, Integer> fuelCache;
    protected final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int $$0) {
            switch ($$0) {
                case 0: {
                    return AbstractFurnaceBlockEntity.this.litTime;
                }
                case 1: {
                    return AbstractFurnaceBlockEntity.this.litDuration;
                }
                case 2: {
                    return AbstractFurnaceBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return AbstractFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int $$0, int $$1) {
            switch ($$0) {
                case 0: {
                    AbstractFurnaceBlockEntity.this.litTime = $$1;
                    break;
                }
                case 1: {
                    AbstractFurnaceBlockEntity.this.litDuration = $$1;
                    break;
                }
                case 2: {
                    AbstractFurnaceBlockEntity.this.cookingProgress = $$1;
                    break;
                }
                case 3: {
                    AbstractFurnaceBlockEntity.this.cookingTotalTime = $$1;
                    break;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2, RecipeType<? extends AbstractCookingRecipe> $$3) {
        super($$0, $$1, $$2);
        this.quickCheck = RecipeManager.createCheck($$3);
    }

    public static void invalidateCache() {
        fuelCache = null;
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> $$0 = fuelCache;
        if ($$0 != null) {
            return $$0;
        }
        LinkedHashMap $$1 = Maps.newLinkedHashMap();
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.LAVA_BUCKET, 20000);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.COAL_BLOCK, 16000);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.BLAZE_ROD, 2400);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.COAL, 1600);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.CHARCOAL, 1600);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.LOGS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.BAMBOO_BLOCKS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.PLANKS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.BAMBOO_MOSAIC, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_STAIRS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.BAMBOO_MOSAIC_STAIRS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_SLABS, 150);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.BAMBOO_MOSAIC_SLAB, 150);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_TRAPDOORS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_PRESSURE_PLATES, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_FENCES, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.FENCE_GATES, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.NOTE_BLOCK, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.BOOKSHELF, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.CHISELED_BOOKSHELF, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.LECTERN, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.JUKEBOX, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.CHEST, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.TRAPPED_CHEST, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.CRAFTING_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.DAYLIGHT_DETECTOR, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.BANNERS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.BOW, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.FISHING_ROD, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.LADDER, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.SIGNS, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.HANGING_SIGNS, 800);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.WOODEN_SHOVEL, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.WOODEN_SWORD, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.WOODEN_HOE, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.WOODEN_AXE, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.WOODEN_PICKAXE, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_DOORS, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.BOATS, 1200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOOL, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOODEN_BUTTONS, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.STICK, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.SAPLINGS, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.BOWL, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, ItemTags.WOOL_CARPETS, 67);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.DRIED_KELP_BLOCK, 4001);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Items.CROSSBOW, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.BAMBOO, 50);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.DEAD_BUSH, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.SCAFFOLDING, 50);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.LOOM, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.BARREL, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.CARTOGRAPHY_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.FLETCHING_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.SMITHING_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.COMPOSTER, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.AZALEA, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.FLOWERING_AZALEA, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)$$1, Blocks.MANGROVE_ROOTS, 300);
        fuelCache = $$1;
        return $$1;
    }

    private static boolean isNeverAFurnaceFuel(Item $$0) {
        return $$0.builtInRegistryHolder().is(ItemTags.NON_FLAMMABLE_WOOD);
    }

    private static void add(Map<Item, Integer> $$0, TagKey<Item> $$1, int $$2) {
        for (Holder<Item> $$3 : BuiltInRegistries.ITEM.getTagOrEmpty($$1)) {
            if (AbstractFurnaceBlockEntity.isNeverAFurnaceFuel($$3.value())) continue;
            $$0.put($$3.value(), $$2);
        }
    }

    private static void add(Map<Item, Integer> $$0, ItemLike $$1, int $$2) {
        Item $$3 = $$1.asItem();
        if (AbstractFurnaceBlockEntity.isNeverAFurnaceFuel($$3)) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw Util.pauseInIde(new IllegalStateException("A developer tried to explicitly make fire resistant item " + $$3.getName(null).getString() + " a furnace fuel. That will not work!"));
            }
            return;
        }
        $$0.put($$3, $$2);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    protected void loadAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
        super.loadAdditional($$0, $$1);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerHelper.loadAllItems($$0, this.items, $$1);
        this.litTime = $$0.getShort("BurnTime");
        this.cookingProgress = $$0.getShort("CookTime");
        this.cookingTotalTime = $$0.getShort("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.items.get(1));
        CompoundTag $$2 = $$0.getCompound("RecipesUsed");
        for (String $$3 : $$2.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse($$3), $$2.getInt($$3));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag $$0, HolderLookup.Provider $$12) {
        super.saveAdditional($$0, $$12);
        $$0.putShort("BurnTime", (short)this.litTime);
        $$0.putShort("CookTime", (short)this.cookingProgress);
        $$0.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerHelper.saveAllItems($$0, this.items, $$12);
        CompoundTag $$22 = new CompoundTag();
        this.recipesUsed.forEach(($$1, $$2) -> $$22.putInt($$1.toString(), (int)$$2));
        $$0.put("RecipesUsed", $$22);
    }

    public static void serverTick(Level $$0, BlockPos $$1, BlockState $$2, AbstractFurnaceBlockEntity $$3) {
        boolean $$9;
        boolean $$4 = $$3.isLit();
        boolean $$5 = false;
        if ($$3.isLit()) {
            --$$3.litTime;
        }
        ItemStack $$6 = $$3.items.get(1);
        ItemStack $$7 = $$3.items.get(0);
        boolean $$8 = !$$7.isEmpty();
        boolean bl = $$9 = !$$6.isEmpty();
        if ($$3.isLit() || $$9 && $$8) {
            RecipeHolder<?> $$11;
            if ($$8) {
                RecipeHolder $$10 = $$3.quickCheck.getRecipeFor(new SingleRecipeInput($$7), $$0).orElse(null);
            } else {
                $$11 = null;
            }
            int $$12 = $$3.getMaxStackSize();
            if (!$$3.isLit() && AbstractFurnaceBlockEntity.canBurn($$0.registryAccess(), $$11, $$3.items, $$12)) {
                $$3.litDuration = $$3.litTime = $$3.getBurnDuration($$6);
                if ($$3.isLit()) {
                    $$5 = true;
                    if ($$9) {
                        Item $$13 = $$6.getItem();
                        $$6.shrink(1);
                        if ($$6.isEmpty()) {
                            Item $$14 = $$13.getCraftingRemainingItem();
                            $$3.items.set(1, $$14 == null ? ItemStack.EMPTY : new ItemStack($$14));
                        }
                    }
                }
            }
            if ($$3.isLit() && AbstractFurnaceBlockEntity.canBurn($$0.registryAccess(), $$11, $$3.items, $$12)) {
                ++$$3.cookingProgress;
                if ($$3.cookingProgress == $$3.cookingTotalTime) {
                    $$3.cookingProgress = 0;
                    $$3.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime($$0, $$3);
                    if (AbstractFurnaceBlockEntity.burn($$0.registryAccess(), $$11, $$3.items, $$12)) {
                        $$3.setRecipeUsed($$11);
                    }
                    $$5 = true;
                }
            } else {
                $$3.cookingProgress = 0;
            }
        } else if (!$$3.isLit() && $$3.cookingProgress > 0) {
            $$3.cookingProgress = Mth.clamp($$3.cookingProgress - 2, 0, $$3.cookingTotalTime);
        }
        if ($$4 != $$3.isLit()) {
            $$5 = true;
            $$2 = (BlockState)$$2.setValue(AbstractFurnaceBlock.LIT, $$3.isLit());
            $$0.setBlock($$1, $$2, 3);
        }
        if ($$5) {
            AbstractFurnaceBlockEntity.setChanged($$0, $$1, $$2);
        }
    }

    private static boolean canBurn(RegistryAccess $$0, @Nullable RecipeHolder<?> $$1, NonNullList<ItemStack> $$2, int $$3) {
        if ($$2.get(0).isEmpty() || $$1 == null) {
            return false;
        }
        ItemStack $$4 = $$1.value().getResultItem($$0);
        if ($$4.isEmpty()) {
            return false;
        }
        ItemStack $$5 = $$2.get(2);
        if ($$5.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents($$5, $$4)) {
            return false;
        }
        if ($$5.getCount() < $$3 && $$5.getCount() < $$5.getMaxStackSize()) {
            return true;
        }
        return $$5.getCount() < $$4.getMaxStackSize();
    }

    private static boolean burn(RegistryAccess $$0, @Nullable RecipeHolder<?> $$1, NonNullList<ItemStack> $$2, int $$3) {
        if ($$1 == null || !AbstractFurnaceBlockEntity.canBurn($$0, $$1, $$2, $$3)) {
            return false;
        }
        ItemStack $$4 = $$2.get(0);
        ItemStack $$5 = $$1.value().getResultItem($$0);
        ItemStack $$6 = $$2.get(2);
        if ($$6.isEmpty()) {
            $$2.set(2, $$5.copy());
        } else if (ItemStack.isSameItemSameComponents($$6, $$5)) {
            $$6.grow(1);
        }
        if ($$4.is(Blocks.WET_SPONGE.asItem()) && !$$2.get(1).isEmpty() && $$2.get(1).is(Items.BUCKET)) {
            $$2.set(1, new ItemStack(Items.WATER_BUCKET));
        }
        $$4.shrink(1);
        return true;
    }

    protected int getBurnDuration(ItemStack $$0) {
        if ($$0.isEmpty()) {
            return 0;
        }
        Item $$1 = $$0.getItem();
        return AbstractFurnaceBlockEntity.getFuel().getOrDefault($$1, 0);
    }

    private static int getTotalCookTime(Level $$02, AbstractFurnaceBlockEntity $$1) {
        SingleRecipeInput $$2 = new SingleRecipeInput($$1.getItem(0));
        return $$1.quickCheck.getRecipeFor($$2, $$02).map($$0 -> ((AbstractCookingRecipe)$$0.value()).getCookingTime()).orElse(200);
    }

    public static boolean isFuel(ItemStack $$0) {
        return AbstractFurnaceBlockEntity.getFuel().containsKey($$0.getItem());
    }

    @Override
    public int[] getSlotsForFace(Direction $$0) {
        if ($$0 == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if ($$0 == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int $$0, ItemStack $$1, @Nullable Direction $$2) {
        return this.canPlaceItem($$0, $$1);
    }

    @Override
    public boolean canTakeItemThroughFace(int $$0, ItemStack $$1, Direction $$2) {
        if ($$2 == Direction.DOWN && $$0 == 1) {
            return $$1.is(Items.WATER_BUCKET) || $$1.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> $$0) {
        this.items = $$0;
    }

    @Override
    public void setItem(int $$0, ItemStack $$1) {
        ItemStack $$2 = this.items.get($$0);
        boolean $$3 = !$$1.isEmpty() && ItemStack.isSameItemSameComponents($$2, $$1);
        this.items.set($$0, $$1);
        $$1.limitSize(this.getMaxStackSize($$1));
        if ($$0 == 0 && !$$3) {
            this.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int $$0, ItemStack $$1) {
        if ($$0 == 2) {
            return false;
        }
        if ($$0 == 1) {
            ItemStack $$2 = this.items.get(1);
            return AbstractFurnaceBlockEntity.isFuel($$1) || $$1.is(Items.BUCKET) && !$$2.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> $$0) {
        if ($$0 != null) {
            ResourceLocation $$1 = $$0.id();
            this.recipesUsed.addTo((Object)$$1, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(Player $$0, List<ItemStack> $$1) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer $$0) {
        List<RecipeHolder<?>> $$1 = this.getRecipesToAwardAndPopExperience($$0.serverLevel(), $$0.position());
        $$0.awardRecipes($$1);
        for (RecipeHolder<?> $$2 : $$1) {
            if ($$2 == null) continue;
            $$0.triggerRecipeCrafted($$2, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel $$0, Vec3 $$1) {
        ArrayList $$2 = Lists.newArrayList();
        for (Object2IntMap.Entry $$3 : this.recipesUsed.object2IntEntrySet()) {
            $$0.getRecipeManager().byKey((ResourceLocation)$$3.getKey()).ifPresent($$4 -> {
                $$2.add($$4);
                AbstractFurnaceBlockEntity.createExperience($$0, $$1, $$3.getIntValue(), ((AbstractCookingRecipe)$$4.value()).getExperience());
            });
        }
        return $$2;
    }

    private static void createExperience(ServerLevel $$0, Vec3 $$1, int $$2, float $$3) {
        int $$4 = Mth.floor((float)$$2 * $$3);
        float $$5 = Mth.frac((float)$$2 * $$3);
        if ($$5 != 0.0f && Math.random() < (double)$$5) {
            ++$$4;
        }
        ExperienceOrb.award($$0, $$1, $$4);
    }

    @Override
    public void fillStackedContents(StackedContents $$0) {
        for (ItemStack $$1 : this.items) {
            $$0.accountStack($$1);
        }
    }
}

