/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootContextParamSets {
    private static final BiMap<ResourceLocation, LootContextParamSet> REGISTRY = HashBiMap.create();
    public static final Codec<LootContextParamSet> CODEC = ResourceLocation.CODEC.comapFlatMap($$0 -> Optional.ofNullable((LootContextParamSet)REGISTRY.get($$0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No parameter set exists with id: '" + String.valueOf($$0) + "'")), arg_0 -> REGISTRY.inverse().get(arg_0));
    public static final LootContextParamSet EMPTY = LootContextParamSets.register("empty", $$0 -> {});
    public static final LootContextParamSet CHEST = LootContextParamSets.register("chest", $$0 -> $$0.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet COMMAND = LootContextParamSets.register("command", $$0 -> $$0.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet SELECTOR = LootContextParamSets.register("selector", $$0 -> $$0.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet FISHING = LootContextParamSets.register("fishing", $$0 -> $$0.required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ENTITY = LootContextParamSets.register("entity", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.ATTACKING_ENTITY).optional(LootContextParams.DIRECT_ATTACKING_ENTITY).optional(LootContextParams.LAST_DAMAGE_PLAYER));
    public static final LootContextParamSet EQUIPMENT = LootContextParamSets.register("equipment", $$0 -> $$0.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ARCHAEOLOGY = LootContextParamSets.register("archaeology", $$0 -> $$0.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet GIFT = LootContextParamSets.register("gift", $$0 -> $$0.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet PIGLIN_BARTER = LootContextParamSets.register("barter", $$0 -> $$0.required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet VAULT = LootContextParamSets.register("vault", $$0 -> $$0.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ADVANCEMENT_REWARD = LootContextParamSets.register("advancement_reward", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet ADVANCEMENT_ENTITY = LootContextParamSets.register("advancement_entity", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet ADVANCEMENT_LOCATION = LootContextParamSets.register("advancement_location", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).required(LootContextParams.BLOCK_STATE));
    public static final LootContextParamSet BLOCK_USE = LootContextParamSets.register("block_use", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE));
    public static final LootContextParamSet ALL_PARAMS = LootContextParamSets.register("generic", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.LAST_DAMAGE_PLAYER).required(LootContextParams.DAMAGE_SOURCE).required(LootContextParams.ATTACKING_ENTITY).required(LootContextParams.DIRECT_ATTACKING_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE).required(LootContextParams.BLOCK_ENTITY).required(LootContextParams.TOOL).required(LootContextParams.EXPLOSION_RADIUS));
    public static final LootContextParamSet BLOCK = LootContextParamSets.register("block", $$0 -> $$0.required(LootContextParams.BLOCK_STATE).required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).optional(LootContextParams.THIS_ENTITY).optional(LootContextParams.BLOCK_ENTITY).optional(LootContextParams.EXPLOSION_RADIUS));
    public static final LootContextParamSet SHEARING = LootContextParamSets.register("shearing", $$0 -> $$0.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ENCHANTED_DAMAGE = LootContextParamSets.register("enchanted_damage", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN).required(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.DIRECT_ATTACKING_ENTITY).optional(LootContextParams.ATTACKING_ENTITY));
    public static final LootContextParamSet ENCHANTED_ITEM = LootContextParamSets.register("enchanted_item", $$0 -> $$0.required(LootContextParams.TOOL).required(LootContextParams.ENCHANTMENT_LEVEL));
    public static final LootContextParamSet ENCHANTED_LOCATION = LootContextParamSets.register("enchanted_location", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN).required(LootContextParams.ENCHANTMENT_ACTIVE));
    public static final LootContextParamSet ENCHANTED_ENTITY = LootContextParamSets.register("enchanted_entity", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet HIT_BLOCK = LootContextParamSets.register("hit_block", $$0 -> $$0.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE));

    private static LootContextParamSet register(String $$0, Consumer<LootContextParamSet.Builder> $$1) {
        LootContextParamSet.Builder $$2 = new LootContextParamSet.Builder();
        $$1.accept($$2);
        LootContextParamSet $$3 = $$2.build();
        ResourceLocation $$4 = ResourceLocation.withDefaultNamespace($$0);
        LootContextParamSet $$5 = (LootContextParamSet)REGISTRY.put((Object)$$4, (Object)$$3);
        if ($$5 != null) {
            throw new IllegalStateException("Loot table parameter set " + String.valueOf($$4) + " is already registered");
        }
        return $$3;
    }
}

