/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestSequence;
import net.minecraft.gametest.framework.GameTestTimeoutException;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.LevelTicks;

public class GameTestInfo {
    private final TestFunction testFunction;
    @Nullable
    private BlockPos structureBlockPos;
    @Nullable
    private BlockPos northWestCorner;
    private final ServerLevel level;
    private final Collection<GameTestListener> listeners = Lists.newArrayList();
    private final int timeoutTicks;
    private final Collection<GameTestSequence> sequences = Lists.newCopyOnWriteArrayList();
    private final Object2LongMap<Runnable> runAtTickTimeMap = new Object2LongOpenHashMap();
    private long startTick;
    private int ticksToWaitForChunkLoading = 20;
    private boolean placedStructure;
    private boolean chunksLoaded;
    private long tickCount;
    private boolean started;
    private final RetryOptions retryOptions;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private boolean done;
    private final Rotation rotation;
    @Nullable
    private Throwable error;
    @Nullable
    private StructureBlockEntity structureBlockEntity;

    public GameTestInfo(TestFunction $$0, Rotation $$1, ServerLevel $$2, RetryOptions $$3) {
        this.testFunction = $$0;
        this.level = $$2;
        this.retryOptions = $$3;
        this.timeoutTicks = $$0.maxTicks();
        this.rotation = $$0.rotation().getRotated($$1);
    }

    void setStructureBlockPos(BlockPos $$0) {
        this.structureBlockPos = $$0;
    }

    public GameTestInfo startExecution(int $$0) {
        this.startTick = this.level.getGameTime() + this.testFunction.setupTicks() + (long)$$0;
        this.timer.start();
        return this;
    }

    public GameTestInfo placeStructure() {
        if (this.placedStructure) {
            return this;
        }
        this.ticksToWaitForChunkLoading = 0;
        this.placedStructure = true;
        StructureBlockEntity $$0 = this.getStructureBlockEntity();
        $$0.placeStructure(this.level);
        BoundingBox $$1 = StructureUtils.getStructureBoundingBox($$0);
        ((LevelTicks)this.level.getBlockTicks()).clearArea($$1);
        this.level.clearBlockEvents($$1);
        return this;
    }

    private boolean ensureStructureIsPlaced() {
        if (this.placedStructure) {
            return true;
        }
        if (this.ticksToWaitForChunkLoading > 0) {
            --this.ticksToWaitForChunkLoading;
            return false;
        }
        this.placeStructure().startExecution(0);
        return true;
    }

    public void tick(GameTestRunner $$02) {
        if (this.isDone()) {
            return;
        }
        if (this.structureBlockEntity == null) {
            this.fail(new IllegalStateException("Running test without structure block entity"));
        }
        if (!this.chunksLoaded && !StructureUtils.getStructureBoundingBox(this.structureBlockEntity).intersectingChunks().allMatch($$0 -> this.level.isPositionEntityTicking($$0.getWorldPosition()))) {
            return;
        }
        this.chunksLoaded = true;
        if (!this.ensureStructureIsPlaced()) {
            return;
        }
        this.tickInternal();
        if (this.isDone()) {
            if (this.error != null) {
                this.listeners.forEach($$1 -> $$1.testFailed(this, $$02));
            } else {
                this.listeners.forEach($$1 -> $$1.testPassed(this, $$02));
            }
        }
    }

    private void tickInternal() {
        this.tickCount = this.level.getGameTime() - this.startTick;
        if (this.tickCount < 0L) {
            return;
        }
        if (!this.started) {
            this.startTest();
        }
        ObjectIterator $$02 = this.runAtTickTimeMap.object2LongEntrySet().iterator();
        while ($$02.hasNext()) {
            Object2LongMap.Entry $$1 = (Object2LongMap.Entry)$$02.next();
            if ($$1.getLongValue() > this.tickCount) continue;
            try {
                ((Runnable)$$1.getKey()).run();
            }
            catch (Exception $$2) {
                this.fail($$2);
            }
            $$02.remove();
        }
        if (this.tickCount > (long)this.timeoutTicks) {
            if (this.sequences.isEmpty()) {
                this.fail(new GameTestTimeoutException("Didn't succeed or fail within " + this.testFunction.maxTicks() + " ticks"));
            } else {
                this.sequences.forEach($$0 -> $$0.tickAndFailIfNotComplete(this.tickCount));
                if (this.error == null) {
                    this.fail(new GameTestTimeoutException("No sequences finished"));
                }
            }
        } else {
            this.sequences.forEach($$0 -> $$0.tickAndContinue(this.tickCount));
        }
    }

    private void startTest() {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            this.testFunction.run(new GameTestHelper(this));
        }
        catch (Exception $$0) {
            this.fail($$0);
        }
    }

    public void setRunAtTickTime(long $$0, Runnable $$1) {
        this.runAtTickTimeMap.put((Object)$$1, $$0);
    }

    public String getTestName() {
        return this.testFunction.testName();
    }

    @Nullable
    public BlockPos getStructureBlockPos() {
        return this.structureBlockPos;
    }

    public AABB getStructureBounds() {
        StructureBlockEntity $$0 = this.getStructureBlockEntity();
        return StructureUtils.getStructureBounds($$0);
    }

    public StructureBlockEntity getStructureBlockEntity() {
        if (this.structureBlockEntity == null) {
            if (this.structureBlockPos == null) {
                throw new IllegalStateException("Could not find a structureBlockEntity for this GameTestInfo");
            }
            this.structureBlockEntity = (StructureBlockEntity)this.level.getBlockEntity(this.structureBlockPos);
            if (this.structureBlockEntity == null) {
                throw new IllegalStateException("Could not find a structureBlockEntity at the given coordinate " + String.valueOf(this.structureBlockPos));
            }
        }
        return this.structureBlockEntity;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean hasSucceeded() {
        return this.done && this.error == null;
    }

    public boolean hasFailed() {
        return this.error != null;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }

    public long getRunTime() {
        return this.timer.elapsed(TimeUnit.MILLISECONDS);
    }

    private void finish() {
        if (!this.done) {
            this.done = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    public void succeed() {
        if (this.error == null) {
            this.finish();
            AABB $$02 = this.getStructureBounds();
            List $$1 = this.getLevel().getEntitiesOfClass(Entity.class, $$02.inflate(1.0), $$0 -> !($$0 instanceof Player));
            $$1.forEach($$0 -> $$0.remove(Entity.RemovalReason.DISCARDED));
        }
    }

    public void fail(Throwable $$0) {
        this.error = $$0;
        this.finish();
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return this.getTestName();
    }

    public void addListener(GameTestListener $$0) {
        this.listeners.add($$0);
    }

    public GameTestInfo prepareTestStructure() {
        BlockPos $$02 = this.getOrCalculateNorthwestCorner();
        this.structureBlockEntity = StructureUtils.prepareTestStructure(this, $$02, this.getRotation(), this.level);
        this.structureBlockPos = this.structureBlockEntity.getBlockPos();
        StructureUtils.addCommandBlockAndButtonToStartTest(this.structureBlockPos, new BlockPos(1, 0, -1), this.getRotation(), this.level);
        StructureUtils.encaseStructure(this.getStructureBounds(), this.level, !this.testFunction.skyAccess());
        this.listeners.forEach($$0 -> $$0.testStructureLoaded(this));
        return this;
    }

    long getTick() {
        return this.tickCount;
    }

    GameTestSequence createSequence() {
        GameTestSequence $$0 = new GameTestSequence(this);
        this.sequences.add($$0);
        return $$0;
    }

    public boolean isRequired() {
        return this.testFunction.required();
    }

    public boolean isOptional() {
        return !this.testFunction.required();
    }

    public String getStructureName() {
        return this.testFunction.structureName();
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public TestFunction getTestFunction() {
        return this.testFunction;
    }

    public int getTimeoutTicks() {
        return this.timeoutTicks;
    }

    public boolean isFlaky() {
        return this.testFunction.isFlaky();
    }

    public int maxAttempts() {
        return this.testFunction.maxAttempts();
    }

    public int requiredSuccesses() {
        return this.testFunction.requiredSuccesses();
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public Stream<GameTestListener> getListeners() {
        return this.listeners.stream();
    }

    public GameTestInfo copyReset() {
        GameTestInfo $$0 = new GameTestInfo(this.testFunction, this.rotation, this.level, this.retryOptions());
        if (this.northWestCorner != null) {
            $$0.setNorthWestCorner(this.northWestCorner);
        }
        if (this.structureBlockPos != null) {
            $$0.setStructureBlockPos(this.structureBlockPos);
        }
        return $$0;
    }

    private BlockPos getOrCalculateNorthwestCorner() {
        if (this.northWestCorner == null) {
            BoundingBox $$0 = StructureUtils.getStructureBoundingBox(this.getStructureBlockEntity());
            this.northWestCorner = new BlockPos($$0.minX(), $$0.minY(), $$0.minZ());
        }
        return this.northWestCorner;
    }

    public void setNorthWestCorner(BlockPos $$0) {
        this.northWestCorner = $$0;
    }
}

