/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class CraftingMenu
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_END = 10;
    private static final int INV_SLOT_START = 10;
    private static final int INV_SLOT_END = 37;
    private static final int USE_ROW_SLOT_START = 37;
    private static final int USE_ROW_SLOT_END = 46;
    private final CraftingContainer craftSlots = new TransientCraftingContainer(this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    private final ContainerLevelAccess access;
    private final Player player;
    private boolean placingRecipe;

    public CraftingMenu(int $$0, Inventory $$1) {
        this($$0, $$1, ContainerLevelAccess.NULL);
    }

    public CraftingMenu(int $$0, Inventory $$1, ContainerLevelAccess $$2) {
        super(MenuType.CRAFTING, $$0);
        this.access = $$2;
        this.player = $$1.player;
        this.addSlot(new ResultSlot($$1.player, this.craftSlots, this.resultSlots, 0, 124, 35));
        for (int $$3 = 0; $$3 < 3; ++$$3) {
            for (int $$4 = 0; $$4 < 3; ++$$4) {
                this.addSlot(new Slot(this.craftSlots, $$4 + $$3 * 3, 30 + $$4 * 18, 17 + $$3 * 18));
            }
        }
        for (int $$5 = 0; $$5 < 3; ++$$5) {
            for (int $$6 = 0; $$6 < 9; ++$$6) {
                this.addSlot(new Slot($$1, $$6 + $$5 * 9 + 9, 8 + $$6 * 18, 84 + $$5 * 18));
            }
        }
        for (int $$7 = 0; $$7 < 9; ++$$7) {
            this.addSlot(new Slot($$1, $$7, 8 + $$7 * 18, 142));
        }
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu $$0, Level $$1, Player $$2, CraftingContainer $$3, ResultContainer $$4, @Nullable RecipeHolder<CraftingRecipe> $$5) {
        if ($$1.isClientSide) {
            return;
        }
        CraftingInput $$6 = $$3.asCraftInput();
        ServerPlayer $$7 = (ServerPlayer)$$2;
        ItemStack $$8 = ItemStack.EMPTY;
        Optional<RecipeHolder<CraftingRecipe>> $$9 = $$1.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, $$6, $$1, $$5);
        if ($$9.isPresent()) {
            ItemStack $$12;
            RecipeHolder<CraftingRecipe> $$10 = $$9.get();
            CraftingRecipe $$11 = $$10.value();
            if ($$4.setRecipeUsed($$1, $$7, $$10) && ($$12 = $$11.assemble($$6, $$1.registryAccess())).isItemEnabled($$1.enabledFeatures())) {
                $$8 = $$12;
            }
        }
        $$4.setItem(0, $$8);
        $$0.setRemoteSlot(0, $$8);
        $$7.connection.send(new ClientboundContainerSetSlotPacket($$0.containerId, $$0.incrementStateId(), 0, $$8));
    }

    @Override
    public void slotsChanged(Container $$02) {
        if (!this.placingRecipe) {
            this.access.execute(($$0, $$1) -> CraftingMenu.slotChangedCraftingGrid(this, $$0, this.player, this.craftSlots, this.resultSlots, null));
        }
    }

    @Override
    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    @Override
    public void finishPlacingRecipe(RecipeHolder<CraftingRecipe> $$0) {
        this.placingRecipe = false;
        this.access.execute(($$1, $$2) -> CraftingMenu.slotChangedCraftingGrid(this, $$1, this.player, this.craftSlots, this.resultSlots, $$0));
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedContents $$0) {
        this.craftSlots.fillStackedContents($$0);
    }

    @Override
    public void clearCraftingContent() {
        this.craftSlots.clearContent();
        this.resultSlots.clearContent();
    }

    @Override
    public boolean recipeMatches(RecipeHolder<CraftingRecipe> $$0) {
        return $$0.value().matches(this.craftSlots.asCraftInput(), this.player.level());
    }

    @Override
    public void removed(Player $$0) {
        super.removed($$0);
        this.access.execute(($$1, $$2) -> this.clearContainer($$0, this.craftSlots));
    }

    @Override
    public boolean stillValid(Player $$0) {
        return CraftingMenu.stillValid(this.access, $$0, Blocks.CRAFTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(Player $$0, int $$1) {
        ItemStack $$22 = ItemStack.EMPTY;
        Slot $$32 = (Slot)this.slots.get($$1);
        if ($$32 != null && $$32.hasItem()) {
            ItemStack $$4 = $$32.getItem();
            $$22 = $$4.copy();
            if ($$1 == 0) {
                this.access.execute(($$2, $$3) -> $$4.getItem().onCraftedBy($$4, (Level)$$2, $$0));
                if (!this.moveItemStackTo($$4, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                $$32.onQuickCraft($$4, $$22);
            } else if ($$1 >= 10 && $$1 < 46 ? !this.moveItemStackTo($$4, 1, 10, false) && ($$1 < 37 ? !this.moveItemStackTo($$4, 37, 46, false) : !this.moveItemStackTo($$4, 10, 37, false)) : !this.moveItemStackTo($$4, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$32.setByPlayer(ItemStack.EMPTY);
            } else {
                $$32.setChanged();
            }
            if ($$4.getCount() == $$22.getCount()) {
                return ItemStack.EMPTY;
            }
            $$32.onTake($$0, $$4);
            if ($$1 == 0) {
                $$0.drop($$4, false);
            }
        }
        return $$22;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack $$0, Slot $$1) {
        return $$1.container != this.resultSlots && super.canTakeItemForPickAll($$0, $$1);
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    @Override
    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    public boolean shouldMoveToInventory(int $$0) {
        return $$0 != this.getResultSlotIndex();
    }
}

