/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;

public class CreativeModeTab {
    static final ResourceLocation DEFAULT_BACKGROUND = CreativeModeTab.createTextureLocation("items");
    private final Component displayName;
    ResourceLocation backgroundTexture = DEFAULT_BACKGROUND;
    boolean canScroll = true;
    boolean showTitle = true;
    boolean alignedRight = false;
    private final Row row;
    private final int column;
    private final Type type;
    @Nullable
    private ItemStack iconItemStack;
    private Collection<ItemStack> displayItems = ItemStackLinkedSet.createTypeAndComponentsSet();
    private Set<ItemStack> displayItemsSearchTab = ItemStackLinkedSet.createTypeAndComponentsSet();
    private final Supplier<ItemStack> iconGenerator;
    private final DisplayItemsGenerator displayItemsGenerator;
    private final boolean hasSearchBar;
    private final int searchBarWidth;
    private final int labelColor;
    private final int slotColor;
    public final List<ResourceLocation> tabsBefore;
    public final List<ResourceLocation> tabsAfter;

    CreativeModeTab(Row p_260217_, int p_259557_, Type p_260176_, Component p_260100_, Supplier<ItemStack> p_259543_, DisplayItemsGenerator p_259085_, Builder builder) {
        this.row = p_260217_;
        this.column = p_259557_;
        this.displayName = p_260100_;
        this.iconGenerator = p_259543_;
        this.displayItemsGenerator = p_259085_;
        this.type = p_260176_;
        this.hasSearchBar = builder.hasSearchBar;
        this.searchBarWidth = builder.searchBarWidth;
        this.labelColor = builder.labelColor;
        this.slotColor = builder.slotColor;
        this.tabsBefore = List.copyOf(builder.tabsBefore);
        this.tabsAfter = List.copyOf(builder.tabsAfter);
    }

    protected CreativeModeTab(Builder builder) {
        this(builder.row, builder.column, builder.type, builder.displayName, builder.iconGenerator, builder.displayItemsGenerator, builder);
    }

    public static Builder builder() {
        return new Builder(Row.TOP, 0);
    }

    public static ResourceLocation createTextureLocation(String p_343491_) {
        return ResourceLocation.withDefaultNamespace("textures/gui/container/creative_inventory/tab_" + p_343491_ + ".png");
    }

    public static Builder builder(Row p_259342_, int p_260312_) {
        return new Builder(p_259342_, p_260312_);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public ItemStack getIconItem() {
        if (this.iconItemStack == null) {
            this.iconItemStack = this.iconGenerator.get();
        }
        return this.iconItemStack;
    }

    public ResourceLocation getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public boolean canScroll() {
        return this.canScroll;
    }

    public int column() {
        return this.column;
    }

    public Row row() {
        return this.row;
    }

    public boolean hasAnyItems() {
        return !this.displayItems.isEmpty();
    }

    public boolean shouldDisplay() {
        return this.type != Type.CATEGORY || this.hasAnyItems();
    }

    public boolean isAlignedRight() {
        return this.alignedRight;
    }

    public Type getType() {
        return this.type;
    }

    public void buildContents(ItemDisplayParameters p_270156_) {
        ItemDisplayBuilder creativemodetab$itemdisplaybuilder = new ItemDisplayBuilder(this, p_270156_.enabledFeatures);
        ResourceKey<CreativeModeTab> resourcekey = BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey(this).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + String.valueOf(this)));
        ForgeHooks.onCreativeModeTabBuildContents((CreativeModeTab)this, resourcekey, (DisplayItemsGenerator)this.displayItemsGenerator, (ItemDisplayParameters)p_270156_, (Output)creativemodetab$itemdisplaybuilder);
        this.displayItems = creativemodetab$itemdisplaybuilder.tabContents;
        this.displayItemsSearchTab = creativemodetab$itemdisplaybuilder.searchTabContents;
    }

    public Collection<ItemStack> getDisplayItems() {
        return this.displayItems;
    }

    public Collection<ItemStack> getSearchTabDisplayItems() {
        return this.displayItemsSearchTab;
    }

    public boolean contains(ItemStack p_259317_) {
        return this.displayItemsSearchTab.contains(p_259317_);
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }

    public int getSearchBarWidth() {
        return this.searchBarWidth;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public int getSlotColor() {
        return this.slotColor;
    }

    public static enum Row {
        TOP,
        BOTTOM;

    }

    @FunctionalInterface
    public static interface DisplayItemsGenerator {
        public void accept(ItemDisplayParameters var1, Output var2);
    }

    public static enum Type {
        CATEGORY,
        INVENTORY,
        HOTBAR,
        SEARCH;

    }

    public static class Builder {
        private static final DisplayItemsGenerator EMPTY_GENERATOR = (p_270422_, p_259433_) -> {};
        private final Row row;
        private final int column;
        private Component displayName = Component.empty();
        private Supplier<ItemStack> iconGenerator = () -> ItemStack.EMPTY;
        private DisplayItemsGenerator displayItemsGenerator = EMPTY_GENERATOR;
        private boolean canScroll = true;
        private boolean showTitle = true;
        private boolean alignedRight = false;
        private Type type = Type.CATEGORY;
        private ResourceLocation backgroundTexture = DEFAULT_BACKGROUND;
        private boolean hasSearchBar = false;
        private int searchBarWidth = 89;
        private int labelColor = 0x404040;
        private int slotColor = -2130706433;
        private Function<Builder, CreativeModeTab> tabFactory = builder -> new CreativeModeTab(builder.row, builder.column, builder.type, builder.displayName, builder.iconGenerator, builder.displayItemsGenerator, (Builder)builder);
        private final List<ResourceLocation> tabsBefore = new ArrayList<ResourceLocation>();
        private final List<ResourceLocation> tabsAfter = new ArrayList<ResourceLocation>();

        public Builder(Row p_259171_, int p_259661_) {
            this.row = p_259171_;
            this.column = p_259661_;
        }

        public Builder title(Component p_259616_) {
            this.displayName = p_259616_;
            return this;
        }

        public Builder icon(Supplier<ItemStack> p_259333_) {
            this.iconGenerator = p_259333_;
            return this;
        }

        public Builder displayItems(DisplayItemsGenerator p_259814_) {
            this.displayItemsGenerator = p_259814_;
            return this;
        }

        public Builder alignedRight() {
            this.alignedRight = true;
            return this;
        }

        public Builder hideTitle() {
            this.showTitle = false;
            return this;
        }

        public Builder noScrollBar() {
            this.canScroll = false;
            return this;
        }

        protected Builder type(Type p_259283_) {
            this.type = p_259283_;
            if (p_259283_ == Type.SEARCH) {
                return this.withSearchBar();
            }
            return this;
        }

        public Builder backgroundTexture(ResourceLocation p_344105_) {
            this.backgroundTexture = p_344105_;
            return this;
        }

        public Builder withSearchBar() {
            this.hasSearchBar = true;
            if (this.backgroundTexture == null) {
                return this.backgroundTexture(CreativeModeTab.createTextureLocation("item_seach"));
            }
            return this;
        }

        public Builder withSearchBar(int searchBarWidth) {
            this.searchBarWidth = searchBarWidth;
            return this.withSearchBar();
        }

        public Builder withLabelColor(int labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder withSlotColor(int slotColor) {
            this.slotColor = slotColor;
            return this;
        }

        public Builder withTabFactory(Function<Builder, CreativeModeTab> tabFactory) {
            this.tabFactory = tabFactory;
            return this;
        }

        public Builder withTabsBefore(ResourceLocation ... tabs) {
            this.tabsBefore.addAll(List.of(tabs));
            return this;
        }

        public Builder withTabsAfter(ResourceLocation ... tabs) {
            this.tabsAfter.addAll(List.of(tabs));
            return this;
        }

        @SafeVarargs
        public final Builder withTabsBefore(ResourceKey<CreativeModeTab> ... tabs) {
            Stream.of(tabs).map(ResourceKey::location).forEach(this.tabsBefore::add);
            return this;
        }

        @SafeVarargs
        public final Builder withTabsAfter(ResourceKey<CreativeModeTab> ... tabs) {
            Stream.of(tabs).map(ResourceKey::location).forEach(this.tabsAfter::add);
            return this;
        }

        public CreativeModeTab build() {
            if ((this.type == Type.HOTBAR || this.type == Type.INVENTORY) && this.displayItemsGenerator != EMPTY_GENERATOR) {
                throw new IllegalStateException("Special tabs can't have display items");
            }
            CreativeModeTab creativemodetab = this.tabFactory.apply(this);
            creativemodetab.alignedRight = this.alignedRight;
            creativemodetab.showTitle = this.showTitle;
            creativemodetab.canScroll = this.canScroll;
            creativemodetab.backgroundTexture = this.backgroundTexture;
            return creativemodetab;
        }
    }

    static class ItemDisplayBuilder
    implements Output {
        public final Collection<ItemStack> tabContents = ItemStackLinkedSet.createTypeAndComponentsSet();
        public final Set<ItemStack> searchTabContents = ItemStackLinkedSet.createTypeAndComponentsSet();
        private final CreativeModeTab tab;
        private final FeatureFlagSet featureFlagSet;

        public ItemDisplayBuilder(CreativeModeTab p_251040_, FeatureFlagSet p_249331_) {
            this.tab = p_251040_;
            this.featureFlagSet = p_249331_;
        }

        @Override
        public void accept(ItemStack p_250391_, TabVisibility p_251472_) {
            boolean flag;
            if (p_250391_.getCount() != 1) {
                throw new IllegalArgumentException("Stack size must be exactly 1");
            }
            boolean bl = flag = this.tabContents.contains(p_250391_) && p_251472_ != TabVisibility.SEARCH_TAB_ONLY;
            if (flag) {
                throw new IllegalStateException("Accidentally adding the same item stack twice " + p_250391_.getDisplayName().getString() + " to a Creative Mode Tab: " + this.tab.getDisplayName().getString());
            }
            if (p_250391_.getItem().isEnabled(this.featureFlagSet)) {
                switch (p_251472_.ordinal()) {
                    case 0: {
                        this.tabContents.add(p_250391_);
                        this.searchTabContents.add(p_250391_);
                        break;
                    }
                    case 1: {
                        this.tabContents.add(p_250391_);
                        break;
                    }
                    case 2: {
                        this.searchTabContents.add(p_250391_);
                    }
                }
            }
        }
    }

    public record ItemDisplayParameters(FeatureFlagSet enabledFeatures, boolean hasPermissions, HolderLookup.Provider holders) {
        public boolean needsUpdate(FeatureFlagSet p_270338_, boolean p_270835_, HolderLookup.Provider p_270575_) {
            return !this.enabledFeatures.equals(p_270338_) || this.hasPermissions != p_270835_ || this.holders != p_270575_;
        }
    }

    public static interface Output {
        public void accept(ItemStack var1, TabVisibility var2);

        default public void accept(ItemStack p_249977_) {
            this.accept(p_249977_, TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        default public void accept(ItemLike p_251528_, TabVisibility p_249821_) {
            this.accept(new ItemStack(p_251528_), p_249821_);
        }

        default public void accept(ItemLike p_248610_) {
            this.accept(new ItemStack(p_248610_), TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        default public void acceptAll(Collection<ItemStack> p_251548_, TabVisibility p_252285_) {
            p_251548_.forEach(p_252337_ -> this.accept((ItemStack)p_252337_, p_252285_));
        }

        default public void acceptAll(Collection<ItemStack> p_250244_) {
            this.acceptAll(p_250244_, TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static enum TabVisibility {
        PARENT_AND_SEARCH_TABS,
        PARENT_TAB_ONLY,
        SEARCH_TAB_ONLY;

    }
}

