/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootContextParamSets {
    private static final BiMap<ResourceLocation, LootContextParamSet> REGISTRY = HashBiMap.create();
    public static final Codec<LootContextParamSet> CODEC = ResourceLocation.CODEC.comapFlatMap(p_297179_ -> Optional.ofNullable((LootContextParamSet)REGISTRY.get(p_297179_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No parameter set exists with id: '" + String.valueOf(p_297179_) + "'")), arg_0 -> REGISTRY.inverse().get(arg_0));
    public static final LootContextParamSet EMPTY = LootContextParamSets.register("empty", p_81454_ -> {});
    public static final LootContextParamSet CHEST = LootContextParamSets.register("chest", p_327636_ -> p_327636_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY).optional(LootContextParams.ATTACKING_ENTITY));
    public static final LootContextParamSet COMMAND = LootContextParamSets.register("command", p_327634_ -> p_327634_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet SELECTOR = LootContextParamSets.register("selector", p_81442_ -> p_81442_.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet FISHING = LootContextParamSets.register("fishing", p_81446_ -> p_81446_.required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).optional(LootContextParams.THIS_ENTITY).optional(LootContextParams.ATTACKING_ENTITY).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ENTITY = LootContextParamSets.register("entity", p_342016_ -> p_342016_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.ATTACKING_ENTITY).optional(LootContextParams.DIRECT_ATTACKING_ENTITY).optional(LootContextParams.LAST_DAMAGE_PLAYER));
    public static final LootContextParamSet EQUIPMENT = LootContextParamSets.register("equipment", p_327637_ -> p_327637_.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ARCHAEOLOGY = LootContextParamSets.register("archaeology", p_81452_ -> p_81452_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet GIFT = LootContextParamSets.register("gift", p_81448_ -> p_81448_.required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet PIGLIN_BARTER = LootContextParamSets.register("barter", p_81440_ -> p_81440_.required(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet VAULT = LootContextParamSets.register("vault", p_81450_ -> p_81450_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ADVANCEMENT_REWARD = LootContextParamSets.register("advancement_reward", p_81438_ -> p_81438_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet ADVANCEMENT_ENTITY = LootContextParamSets.register("advancement_entity", p_81436_ -> p_81436_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet ADVANCEMENT_LOCATION = LootContextParamSets.register("advancement_location", p_286218_ -> p_286218_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).required(LootContextParams.BLOCK_STATE));
    public static final LootContextParamSet BLOCK_USE = LootContextParamSets.register("block_use", p_327633_ -> p_327633_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE));
    public static final LootContextParamSet ALL_PARAMS = LootContextParamSets.register("generic", p_342015_ -> p_342015_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.LAST_DAMAGE_PLAYER).required(LootContextParams.DAMAGE_SOURCE).required(LootContextParams.ATTACKING_ENTITY).required(LootContextParams.DIRECT_ATTACKING_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE).required(LootContextParams.BLOCK_ENTITY).required(LootContextParams.TOOL).required(LootContextParams.EXPLOSION_RADIUS));
    public static final LootContextParamSet BLOCK = LootContextParamSets.register("block", p_81425_ -> p_81425_.required(LootContextParams.BLOCK_STATE).required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).optional(LootContextParams.THIS_ENTITY).optional(LootContextParams.BLOCK_ENTITY).optional(LootContextParams.EXPLOSION_RADIUS));
    public static final LootContextParamSet SHEARING = LootContextParamSets.register("shearing", p_272589_ -> p_272589_.required(LootContextParams.ORIGIN).optional(LootContextParams.THIS_ENTITY));
    public static final LootContextParamSet ENCHANTED_DAMAGE = LootContextParamSets.register("enchanted_damage", p_342018_ -> p_342018_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN).required(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.DIRECT_ATTACKING_ENTITY).optional(LootContextParams.ATTACKING_ENTITY));
    public static final LootContextParamSet ENCHANTED_ITEM = LootContextParamSets.register("enchanted_item", p_342017_ -> p_342017_.required(LootContextParams.TOOL).required(LootContextParams.ENCHANTMENT_LEVEL));
    public static final LootContextParamSet ENCHANTED_LOCATION = LootContextParamSets.register("enchanted_location", p_342019_ -> p_342019_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN).required(LootContextParams.ENCHANTMENT_ACTIVE));
    public static final LootContextParamSet ENCHANTED_ENTITY = LootContextParamSets.register("enchanted_entity", p_342014_ -> p_342014_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN));
    public static final LootContextParamSet HIT_BLOCK = LootContextParamSets.register("hit_block", p_342020_ -> p_342020_.required(LootContextParams.THIS_ENTITY).required(LootContextParams.ENCHANTMENT_LEVEL).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE));

    private static LootContextParamSet register(String p_81429_, Consumer<LootContextParamSet.Builder> p_81430_) {
        LootContextParamSet.Builder lootcontextparamset$builder = new LootContextParamSet.Builder();
        p_81430_.accept(lootcontextparamset$builder);
        LootContextParamSet lootcontextparamset = lootcontextparamset$builder.build();
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace(p_81429_);
        LootContextParamSet lootcontextparamset1 = (LootContextParamSet)REGISTRY.put((Object)resourcelocation, (Object)lootcontextparamset);
        if (lootcontextparamset1 != null) {
            throw new IllegalStateException("Loot table parameter set " + String.valueOf(resourcelocation) + " is already registered");
        }
        return lootcontextparamset;
    }
}

