/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.common.CreativeModeTabRegistry;
import org.jetbrains.annotations.Nullable;

public class CreativeModeTabSearchRegistry {
    private static final Map<CreativeModeTab, SessionSearchTrees.Key> NAME_SEARCH_KEYS = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
    private static final Map<CreativeModeTab, SessionSearchTrees.Key> TAG_SEARCH_KEYS = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();

    public static Map<CreativeModeTab, SessionSearchTrees.Key> getNameSearchKeys() {
        IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key> nameSearchKeys = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
        nameSearchKeys.put(CreativeModeTabs.searchTab(), CreativeModeTabSearchRegistry.getNameSearchKey(CreativeModeTabs.searchTab()));
        for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
            SessionSearchTrees.Key nameSearchKey = CreativeModeTabSearchRegistry.getNameSearchKey(tab);
            if (nameSearchKey == null) continue;
            nameSearchKeys.put(tab, nameSearchKey);
        }
        return nameSearchKeys;
    }

    public static Map<CreativeModeTab, SessionSearchTrees.Key> getTagSearchKeys() {
        IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key> tagSearchKeys = new IdentityHashMap<CreativeModeTab, SessionSearchTrees.Key>();
        tagSearchKeys.put(CreativeModeTabs.searchTab(), CreativeModeTabSearchRegistry.getTagSearchKey(CreativeModeTabs.searchTab()));
        for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
            SessionSearchTrees.Key tagSearchKey = CreativeModeTabSearchRegistry.getTagSearchKey(tab);
            if (tagSearchKey == null) continue;
            tagSearchKeys.put(tab, tagSearchKey);
        }
        return tagSearchKeys;
    }

    @Nullable
    public static SessionSearchTrees.Key getNameSearchKey(CreativeModeTab tab) {
        if (tab == CreativeModeTabs.searchTab()) {
            return SessionSearchTrees.CREATIVE_NAMES;
        }
        if (!tab.hasSearchBar()) {
            return null;
        }
        return NAME_SEARCH_KEYS.computeIfAbsent(tab, k -> new SessionSearchTrees.Key());
    }

    @Nullable
    public static SessionSearchTrees.Key getTagSearchKey(CreativeModeTab tab) {
        if (tab == CreativeModeTabs.searchTab()) {
            return SessionSearchTrees.CREATIVE_TAGS;
        }
        if (!tab.hasSearchBar()) {
            return null;
        }
        return TAG_SEARCH_KEYS.computeIfAbsent(tab, k -> new SessionSearchTrees.Key());
    }
}

