/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public class RegisterRecipeBookCategoriesEvent
extends Event
implements IModBusEvent {
    private final Map<RecipeBookCategories, List<RecipeBookCategories>> aggregateCategories;
    private final Map<RecipeBookType, List<RecipeBookCategories>> typeCategories;
    private final Map<RecipeType<?>, Function<Recipe<?>, RecipeBookCategories>> recipeCategoryLookups;

    @ApiStatus.Internal
    public RegisterRecipeBookCategoriesEvent(Map<RecipeBookCategories, List<RecipeBookCategories>> aggregateCategories, Map<RecipeBookType, List<RecipeBookCategories>> typeCategories, Map<RecipeType<?>, Function<Recipe<?>, RecipeBookCategories>> recipeCategoryLookups) {
        this.aggregateCategories = aggregateCategories;
        this.typeCategories = typeCategories;
        this.recipeCategoryLookups = recipeCategoryLookups;
    }

    public void registerAggregateCategory(RecipeBookCategories category, List<RecipeBookCategories> others) {
        this.aggregateCategories.put(category, List.copyOf(others));
    }

    public void registerBookCategories(RecipeBookType type, List<RecipeBookCategories> categories) {
        this.typeCategories.put(type, List.copyOf(categories));
    }

    public void registerRecipeCategoryFinder(RecipeType<?> type, Function<Recipe<?>, RecipeBookCategories> lookup) {
        this.recipeCategoryLookups.put(type, lookup);
    }
}

