/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;

public final class TagConventionMappings {
    public static final Map<TagKey<?>, String> MAPPINGS = Map.ofEntries(TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("barrels"), Tags.Blocks.BARRELS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("barrels/wooden"), Tags.Blocks.BARRELS_WOODEN), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("bookshelves"), Tags.Blocks.BOOKSHELVES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("chests"), Tags.Blocks.CHESTS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("chests/wooden"), Tags.Blocks.CHESTS_WOODEN), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("cobblestone"), Tags.Blocks.COBBLESTONES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass"), Tags.Blocks.GLASS_BLOCKS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/black"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_BLACK)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/blue"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_BLUE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/brown"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_BROWN)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/colorless"), Tags.Blocks.GLASS_BLOCKS_COLORLESS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/cyan"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_CYAN)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/gray"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_GRAY)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/green"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_GREEN)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/light_blue"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_LIGHT_BLUE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/light_gray"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_LIGHT_GRAY)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/lime"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_LIME)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/magenta"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_MAGENTA)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/orange"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_ORANGE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/pink"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_PINK)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/purple"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_PURPLE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/red"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_RED)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/silica"), Tags.Blocks.GLASS_BLOCKS_CHEAP), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/tinted"), Tags.Blocks.GLASS_BLOCKS_TINTED), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/white"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_WHITE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass/yellow"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Items.DYED_YELLOW)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes"), Tags.Blocks.GLASS_PANES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/colorless"), Tags.Blocks.GLASS_PANES_COLORLESS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/black"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_BLACK)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/blue"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_BLUE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/brown"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_BROWN)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/cyan"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_CYAN)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/gray"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_GRAY)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/green"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_GREEN)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/light_blue"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_LIGHT_BLUE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/light_gray"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_LIGHT_GRAY)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/lime"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_LIME)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/magenta"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_MAGENTA)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/orange"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_ORANGE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/pink"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_PINK)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/purple"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_PURPLE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/red"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_RED)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/white"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_WHITE)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("glass_panes/yellow"), List.of(Tags.Blocks.GLASS_PANES, Tags.Items.DYED_YELLOW)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("obsidian"), Tags.Blocks.OBSIDIANS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("ores"), Tags.Blocks.ORES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("ores/netherite_scrap"), Tags.Blocks.ORES_NETHERITE_SCRAP), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("ores/quartz"), Tags.Blocks.ORES_QUARTZ), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("sandstone"), Tags.Blocks.SANDSTONE_BLOCKS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("stained_glass"), List.of(Tags.Blocks.GLASS_BLOCKS, Tags.Blocks.DYED)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("stained_glass_panes"), List.of(Tags.Blocks.GLASS_PANES, Tags.Blocks.DYED)), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("stone"), Tags.Blocks.STONES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks"), Tags.Blocks.STORAGE_BLOCKS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/coal"), Tags.Blocks.STORAGE_BLOCKS_COAL), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/copper"), Tags.Blocks.STORAGE_BLOCKS_COPPER), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/diamond"), Tags.Blocks.STORAGE_BLOCKS_DIAMOND), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/emerald"), Tags.Blocks.STORAGE_BLOCKS_EMERALD), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/gold"), Tags.Blocks.STORAGE_BLOCKS_GOLD), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/iron"), Tags.Blocks.STORAGE_BLOCKS_IRON), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/lapis"), Tags.Blocks.STORAGE_BLOCKS_LAPIS), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/netherite"), Tags.Blocks.STORAGE_BLOCKS_NETHERITE), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/quartz"), Tags.Blocks.STORAGE_BLOCKS_QUARTZ), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/raw_copper"), Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/raw_gold"), Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/raw_iron"), Tags.Blocks.STORAGE_BLOCKS_RAW_IRON), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("storage_blocks/redstone"), Tags.Blocks.STORAGE_BLOCKS_REDSTONE), TagConventionMappings.legacyToCommon(Registries.ENTITY_TYPE, TagConventionMappings.forgeRl("bosses"), Tags.EntityTypes.BOSSES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("barrels"), Tags.Items.BARRELS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("barrels/wooden"), Tags.Items.BARRELS_WOODEN), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("bookshelves"), Tags.Items.BOOKSHELVES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("chests"), Tags.Items.CHESTS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("chests/wooden"), Tags.Items.CHESTS_WOODEN), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cobblestone"), Tags.Items.COBBLESTONES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crops"), Tags.Items.CROPS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crops/beetroot"), Tags.Items.CROPS_BEETROOT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crops/carrot"), Tags.Items.CROPS_CARROT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crops/potato"), Tags.Items.CROPS_POTATO), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crops/wheat"), Tags.Items.CROPS_WHEAT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dusts"), Tags.Items.DUSTS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dusts/redstone"), Tags.Items.DUSTS_REDSTONE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dusts/glowstone"), Tags.Items.DUSTS_GLOWSTONE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes"), Tags.Items.DYES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/black"), Tags.Items.DYES_BLACK), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/red"), Tags.Items.DYES_RED), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/green"), Tags.Items.DYES_GREEN), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/brown"), Tags.Items.DYES_BROWN), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/blue"), Tags.Items.DYES_BLUE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/purple"), Tags.Items.DYES_PURPLE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/cyan"), Tags.Items.DYES_CYAN), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/light_gray"), Tags.Items.DYES_LIGHT_GRAY), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/gray"), Tags.Items.DYES_GRAY), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/pink"), Tags.Items.DYES_PINK), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/lime"), Tags.Items.DYES_LIME), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/yellow"), Tags.Items.DYES_YELLOW), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/light_blue"), Tags.Items.DYES_LIGHT_BLUE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/magenta"), Tags.Items.DYES_MAGENTA), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/orange"), Tags.Items.DYES_ORANGE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("dyes/white"), Tags.Items.DYES_WHITE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ender_pearls"), Tags.Items.ENDER_PEARLS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("foods/pie"), Tags.Items.FOODS_PIE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("gems"), Tags.Items.GEMS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("gems/diamond"), Tags.Items.GEMS_DIAMOND), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("gems/emerald"), Tags.Items.GEMS_EMERALD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("gems/amethyst"), Tags.Items.GEMS_AMETHYST), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("gems/lapis"), Tags.Items.GEMS_LAPIS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("gems/quartz"), Tags.Items.GEMS_QUARTZ), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass"), Tags.Items.GLASS_BLOCKS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/black"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_BLACK)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/blue"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_BLUE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/brown"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_BROWN)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/colorless"), Tags.Items.GLASS_BLOCKS_COLORLESS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/cyan"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_CYAN)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/gray"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_GRAY)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/green"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_GREEN)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/light_blue"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_LIGHT_BLUE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/light_gray"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_LIGHT_GRAY)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/lime"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_LIME)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/magenta"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_MAGENTA)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/orange"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_ORANGE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/pink"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_PINK)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/purple"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_PURPLE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/red"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_RED)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/silica"), Tags.Items.GLASS_BLOCKS_CHEAP), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/tinted"), Tags.Items.GLASS_BLOCKS_TINTED), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/white"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_WHITE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass/yellow"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Items.DYED_YELLOW)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes"), Tags.Items.GLASS_PANES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/black"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_BLACK)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/blue"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_BLUE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/brown"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_BROWN)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/colorless"), Tags.Items.GLASS_PANES_COLORLESS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/cyan"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_CYAN)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/gray"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_GRAY)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/green"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_GREEN)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/light_blue"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_LIGHT_BLUE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/light_gray"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_LIGHT_GRAY)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/lime"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_LIME)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/magenta"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_MAGENTA)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/orange"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_ORANGE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/pink"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_PINK)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/purple"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_PURPLE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/red"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_RED)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/white"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_WHITE)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("glass_panes/yellow"), List.of(Tags.Items.GLASS_PANES, Tags.Items.DYED_YELLOW)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("obsidian"), Tags.Items.OBSIDIANS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots"), Tags.Items.INGOTS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots/brick"), Tags.Items.BRICKS_NORMAL), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots/copper"), Tags.Items.INGOTS_COPPER), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots/gold"), Tags.Items.INGOTS_GOLD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots/iron"), Tags.Items.INGOTS_IRON), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots/netherite"), Tags.Items.INGOTS_NETHERITE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ingots/nether_brick"), Tags.Items.BRICKS_NETHER), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("leather"), Tags.Items.LEATHERS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("nuggets"), Tags.Items.NUGGETS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("nuggets/gold"), Tags.Items.NUGGETS_GOLD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("nuggets/iron"), Tags.Items.NUGGETS_IRON), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ores"), Tags.Items.ORES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ores/netherite_scrap"), Tags.Items.ORES_NETHERITE_SCRAP), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("ores/quartz"), Tags.Items.ORES_QUARTZ), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_materials"), Tags.Items.RAW_MATERIALS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_materials/copper"), Tags.Items.RAW_MATERIALS_COPPER), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_materials/gold"), Tags.Items.RAW_MATERIALS_GOLD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_materials/iron"), Tags.Items.RAW_MATERIALS_IRON), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("rods"), Tags.Items.RODS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("rods/blaze"), Tags.Items.RODS_BLAZE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("rods/wooden"), Tags.Items.RODS_WOODEN), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("sandstone"), Tags.Items.SANDSTONE_BLOCKS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("slimeballs"), Tags.Items.SLIME_BALLS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("stained_glass"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Blocks.DYED)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("stained_glass_panes"), List.of(Tags.Items.GLASS_BLOCKS, Tags.Blocks.DYED)), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("stone"), Tags.Items.STONES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks"), Tags.Items.STORAGE_BLOCKS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/coal"), Tags.Items.STORAGE_BLOCKS_COAL), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/copper"), Tags.Items.STORAGE_BLOCKS_COPPER), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/diamond"), Tags.Items.STORAGE_BLOCKS_DIAMOND), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/emerald"), Tags.Items.STORAGE_BLOCKS_EMERALD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/gold"), Tags.Items.STORAGE_BLOCKS_GOLD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/iron"), Tags.Items.STORAGE_BLOCKS_IRON), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/lapis"), Tags.Items.STORAGE_BLOCKS_LAPIS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/netherite"), Tags.Items.STORAGE_BLOCKS_NETHERITE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/quartz"), Tags.Items.STORAGE_BLOCKS_QUARTZ), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/raw_copper"), Tags.Items.STORAGE_BLOCKS_RAW_COPPER), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/raw_gold"), Tags.Items.STORAGE_BLOCKS_RAW_GOLD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/raw_iron"), Tags.Items.STORAGE_BLOCKS_RAW_IRON), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("storage_blocks/redstone"), Tags.Items.STORAGE_BLOCKS_REDSTONE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("string"), Tags.Items.STRINGS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools"), Tags.Items.TOOLS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools/shields"), Tags.Items.TOOLS_SHIELD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools/bows"), Tags.Items.TOOLS_BOW), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools/crossbows"), Tags.Items.TOOLS_CROSSBOW), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools/fishing_rods"), Tags.Items.TOOLS_FISHING_ROD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools/tridents"), Tags.Items.TOOLS_SPEAR), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("tools/shears"), Tags.Items.TOOLS_SHEAR), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("armors"), Tags.Items.ARMORS), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("milk"), Tags.Fluids.MILK), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("gaseous"), Tags.Fluids.GASEOUS), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("potion"), Tags.Fluids.POTION), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("suspicious_stew"), Tags.Fluids.SUSPICIOUS_STEW), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("mushroom_stew"), Tags.Fluids.MUSHROOM_STEW), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("rabbit_stew"), Tags.Fluids.RABBIT_STEW), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("beetroot_soup"), Tags.Fluids.BEETROOT_SOUP), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_void"), Tags.Biomes.IS_VOID), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_hot"), Tags.Biomes.IS_HOT), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_hot/overworld"), Tags.Biomes.IS_HOT_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_hot/nether"), Tags.Biomes.IS_HOT_NETHER), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_cold"), Tags.Biomes.IS_COLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_cold/overworld"), Tags.Biomes.IS_COLD_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_cold/end"), Tags.Biomes.IS_COLD_END), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_sparse"), Tags.Biomes.IS_SPARSE_VEGETATION), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_sparse/overworld"), Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dense"), Tags.Biomes.IS_DENSE_VEGETATION), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dense/overworld"), Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_wet"), Tags.Biomes.IS_WET), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_wet/overworld"), Tags.Biomes.IS_WET_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dry"), Tags.Biomes.IS_DRY), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dry/overworld"), Tags.Biomes.IS_DRY_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dry/nether"), Tags.Biomes.IS_DRY_NETHER), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dry/end"), Tags.Biomes.IS_DRY_END), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_coniferous"), Tags.Biomes.IS_CONIFEROUS_TREE), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_mountain"), Tags.Biomes.IS_MOUNTAIN), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_peak"), Tags.Biomes.IS_MOUNTAIN_PEAK), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_slope"), Tags.Biomes.IS_MOUNTAIN_SLOPE), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_plains"), Tags.Biomes.IS_PLAINS), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_swamp"), Tags.Biomes.IS_SWAMP), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_desert"), Tags.Biomes.IS_DESERT), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_mushroom"), Tags.Biomes.IS_MUSHROOM), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_underground"), Tags.Biomes.IS_UNDERGROUND), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_cave"), Tags.Biomes.IS_CAVE), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_wasteland"), Tags.Biomes.IS_WASTELAND), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_dead"), Tags.Biomes.IS_DEAD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_water"), Tags.Biomes.IS_AQUATIC), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("crafting_table"), Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("crafting_tables"), Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("furnace"), Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("furnaces"), Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("workbench"), Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.BLOCK, TagConventionMappings.forgeRl("workbenches"), Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crafting_table"), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("crafting_tables"), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("furnace"), Tags.Items.PLAYER_WORKSTATIONS_FURNACES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("furnaces"), Tags.Items.PLAYER_WORKSTATIONS_FURNACES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("workbench"), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("workbenches"), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("food"), Tags.Items.FOODS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("foods"), Tags.Items.FOODS), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("fruit"), Tags.Items.FOODS_FRUIT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("fruits"), Tags.Items.FOODS_FRUIT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("vegetable"), Tags.Items.FOODS_VEGETABLE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("vegetables"), Tags.Items.FOODS_VEGETABLE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("berry"), Tags.Items.FOODS_BERRY), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("berries"), Tags.Items.FOODS_BERRY), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("bread"), Tags.Items.FOODS_BREAD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("breads"), Tags.Items.FOODS_BREAD), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cookie"), Tags.Items.FOODS_COOKIE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cookies"), Tags.Items.FOODS_COOKIE), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_meat"), Tags.Items.FOODS_RAW_MEAT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_meats"), Tags.Items.FOODS_RAW_MEAT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_fish"), Tags.Items.FOODS_RAW_FISH), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("raw_fishes"), Tags.Items.FOODS_RAW_FISH), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cooked_meat"), Tags.Items.FOODS_COOKED_MEAT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cooked_meats"), Tags.Items.FOODS_COOKED_MEAT), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cooked_fish"), Tags.Items.FOODS_COOKED_FISH), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("cooked_fishes"), Tags.Items.FOODS_COOKED_FISH), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("soup"), Tags.Items.FOODS_SOUP), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("soups"), Tags.Items.FOODS_SOUP), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("stew"), Tags.Items.FOODS_SOUP), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("stews"), Tags.Items.FOODS_SOUP), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("candy"), Tags.Items.FOODS_CANDY), TagConventionMappings.legacyToCommon(Registries.ITEM, TagConventionMappings.forgeRl("candies"), Tags.Items.FOODS_CANDY), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("water"), Tags.Fluids.WATER), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("lava"), Tags.Fluids.LAVA), TagConventionMappings.legacyToCommon(Registries.FLUID, TagConventionMappings.forgeRl("honey"), Tags.Fluids.HONEY), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_overworld"), Tags.Biomes.IS_OVERWORLD), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_nether"), Tags.Biomes.IS_NETHER), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_nether_forest"), Tags.Biomes.IS_NETHER_FOREST), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_end"), Tags.Biomes.IS_END), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_forest"), Tags.Biomes.IS_FOREST), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_jungle"), Tags.Biomes.IS_JUNGLE), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_savanna"), Tags.Biomes.IS_SAVANNA), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_floral"), Tags.Biomes.IS_FLORAL), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_snowy"), Tags.Biomes.IS_SNOWY), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_icy"), Tags.Biomes.IS_ICY), TagConventionMappings.legacyToCommon(Registries.BIOME, TagConventionMappings.forgeRl("is_ocean"), Tags.Biomes.IS_OCEAN));

    private TagConventionMappings() {
    }

    private static <T, R> Map.Entry<TagKey<T>, String> legacyToCommon(ResourceKey<Registry<T>> registryKey, ResourceLocation legacyTagResourceLocation, TagKey<R> replacementTag) {
        return Map.entry(TagKey.create(registryKey, (ResourceLocation)legacyTagResourceLocation), replacementTag.toString());
    }

    private static <T> Map.Entry<TagKey<T>, String> legacyToCommon(ResourceKey<Registry<T>> registryKey, ResourceLocation legacyTagRessourceLocation, List<TagKey<?>> replacementTags) {
        return Map.entry(TagKey.create(registryKey, (ResourceLocation)legacyTagRessourceLocation), replacementTags.stream().map(TagKey::toString).collect(Collectors.joining(" and ")));
    }

    private static ResourceLocation forgeRl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path);
    }
}

