/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public interface IIngredientSerializer<T extends Ingredient> {
    public static final IIngredientSerializer<Ingredient> VANILLA = new IIngredientSerializer<Ingredient>(){

        @Override
        public MapCodec<? extends Ingredient> codec() {
            return Ingredient.VANILLA_MAP_CODEC;
        }

        @Override
        public void write(RegistryFriendlyByteBuf buffer, Ingredient value) {
            ItemStack.LIST_STREAM_CODEC.encode((Object)buffer, Arrays.asList(value.getItems()));
        }

        @Override
        public Ingredient read(RegistryFriendlyByteBuf buffer) {
            return Ingredient.of(((List)ItemStack.LIST_STREAM_CODEC.decode((Object)buffer)).stream());
        }
    };

    public MapCodec<? extends T> codec();

    public void write(RegistryFriendlyByteBuf var1, T var2);

    public T read(RegistryFriendlyByteBuf var1);
}

