/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeFluidTagsProvider
extends FluidTagsProvider {
    public ForgeFluidTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider lookupProvider) {
        this.tag(Tags.Fluids.WATER).add((Object)Fluids.WATER).add((Object)Fluids.FLOWING_WATER);
        this.tag(Tags.Fluids.LAVA).add((Object)Fluids.LAVA).add((Object)Fluids.FLOWING_LAVA);
        this.tag(Tags.Fluids.MILK).addOptional(ForgeMod.MILK.getId()).addOptional(ForgeMod.FLOWING_MILK.getId());
        this.tag(Tags.Fluids.GASEOUS).addOptionalTag(ForgeFluidTagsProvider.forgeTagKey("gaseous"));
        this.tag(Tags.Fluids.HONEY);
        this.tag(Tags.Fluids.EXPERIENCE);
        this.tag(Tags.Fluids.POTION).addOptionalTag(ForgeFluidTagsProvider.forgeTagKey("potion"));
        this.tag(Tags.Fluids.SUSPICIOUS_STEW).addOptionalTag(ForgeFluidTagsProvider.forgeTagKey("suspicious_stew"));
        this.tag(Tags.Fluids.MUSHROOM_STEW).addOptionalTag(ForgeFluidTagsProvider.forgeTagKey("mushroom_stew"));
        this.tag(Tags.Fluids.RABBIT_STEW).addOptionalTag(ForgeFluidTagsProvider.forgeTagKey("rabbit_stew"));
        this.tag(Tags.Fluids.BEETROOT_SOUP).addOptionalTag(ForgeFluidTagsProvider.forgeTagKey("beetroot_soup"));
        this.tag(Tags.Fluids.HIDDEN_FROM_RECIPE_VIEWERS);
        this.tag(ForgeFluidTagsProvider.forgeTagKey("milk")).addOptional(ForgeMod.MILK.getId()).addOptional(ForgeMod.FLOWING_MILK.getId());
        this.tag(ForgeFluidTagsProvider.forgeTagKey("gaseous"));
        this.tag(ForgeFluidTagsProvider.forgeTagKey("potion"));
        this.tag(ForgeFluidTagsProvider.forgeTagKey("suspicious_stew"));
        this.tag(ForgeFluidTagsProvider.forgeTagKey("mushroom_stew"));
        this.tag(ForgeFluidTagsProvider.forgeTagKey("rabbit_stew"));
        this.tag(ForgeFluidTagsProvider.forgeTagKey("beetroot_soup"));
    }

    private static TagKey<Fluid> forgeTagKey(String path) {
        return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge Fluid Tags";
    }
}

