/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraftforge.common.WorldWorkerManager;

public class ChunkGenWorker
implements WorldWorkerManager.IWorker {
    private final CommandSourceStack listener;
    protected final BlockPos start;
    protected final int total;
    private final ServerLevel dim;
    private final Queue<BlockPos> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotifcationTime = 0L;
    private int genned = 0;
    private Boolean keepingLoaded;

    public ChunkGenWorker(CommandSourceStack listener, BlockPos start, int total, ServerLevel dim, int interval) {
        this.listener = listener;
        this.start = start;
        this.total = total;
        this.dim = dim;
        this.queue = this.buildQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max(total / 20, 100);
        this.lastNotifcationTime = System.currentTimeMillis();
    }

    protected Queue<BlockPos> buildQueue() {
        ArrayDeque<BlockPos> ret = new ArrayDeque<BlockPos>();
        ret.add(this.start);
        int radius = 1;
        while (ret.size() < this.total) {
            int q;
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.offset(radius, 0, q));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.offset(q, 0, radius));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.offset(-radius, 0, q));
            }
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.offset(q, 0, -radius));
            }
            ++radius;
        }
        return ret;
    }

    public MutableComponent getStartMessage(CommandSourceStack sender) {
        return Component.translatable((String)"commands.forge.gen.start", (Object[])new Object[]{this.total, this.start.getX(), this.start.getZ(), this.dim});
    }

    @Override
    public boolean hasWork() {
        return !this.queue.isEmpty();
    }

    @Override
    public boolean doWork() {
        BlockPos next = this.queue.poll();
        if (next != null) {
            ChunkAccess chunk;
            int z;
            int x;
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotifcationTime < System.currentTimeMillis() - 60000L) {
                this.listener.sendSuccess(() -> Component.translatable((String)"commands.forge.gen.progress", (Object[])new Object[]{this.total - this.queue.size(), this.total}), true);
                this.lastNotification = 0;
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            if (!this.dim.hasChunk(x = next.getX(), z = next.getZ()) && !(chunk = this.dim.getChunk(x, z, ChunkStatus.EMPTY, true)).getPersistedStatus().isOrAfter(ChunkStatus.FULL)) {
                chunk = this.dim.getChunk(x, z, ChunkStatus.FULL);
                ++this.genned;
            }
        }
        if (this.queue.isEmpty()) {
            this.listener.sendSuccess(() -> Component.translatable((String)"commands.forge.gen.complete", (Object[])new Object[]{this.genned, this.total, this.dim.dimension().location()}), true);
            return false;
        }
        return true;
    }
}

