/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;

public class RuntimeEnumExtender
implements ILaunchPluginService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Type STRING = Type.getType(String.class);
    private static final Type ENUM = Type.getType(Enum.class);
    private static final Type MARKER_IFACE = Type.getType((String)"Lnet/minecraftforge/common/IExtensibleEnum;");
    private static final Type ARRAY_UTILS = Type.getType((String)"Lorg/apache/commons/lang3/ArrayUtils;");
    private static final String ADD_DESC = Type.getMethodDescriptor((Type)Type.getType(Object[].class), (Type[])new Type[]{Type.getType(Object[].class), Type.getType(Object.class)});
    private static final Type UNSAFE_HACKS = Type.getType((String)"Lnet/minecraftforge/fml/unsafe/UnsafeHacks;");
    private static final String CLEAN_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Class.class)});
    private static final String NAME_DESC = Type.getMethodDescriptor((Type)STRING, (Type[])new Type[0]);
    private static final String EQUALS_DESC = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING});
    private static final int FLAGS = 4122;
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);

    public String name() {
        return "runtime_enum_extender";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return isEmpty ? NAY : YAY;
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if ((classNode.access & 0x4000) == 0) {
            return 0;
        }
        Type array = Type.getType((String)("[" + classType.getDescriptor()));
        String arrayDesc = array.getDescriptor();
        FieldNode values = classNode.fields.stream().filter(f -> f.desc.equals(arrayDesc) && (f.access & 0x101A) == 4122).findFirst().orElse(null);
        if (!classNode.interfaces.contains(MARKER_IFACE.getInternalName())) {
            return 0;
        }
        List<MethodNode> candidates = classNode.methods.stream().filter(m -> (m.access & 8) != 0 && m.name.equals("create")).toList();
        if (candidates.isEmpty()) {
            throw new IllegalStateException("IExtensibleEnum has no candidate factory methods: " + classType.getClassName());
        }
        for (MethodNode mtd : candidates) {
            StringBuilder sb;
            Type[] args = Type.getArgumentTypes((String)mtd.desc);
            if (args.length == 0 || !args[0].equals((Object)STRING)) {
                if (LOGGER.isErrorEnabled(LogUtils.FATAL_MARKER)) {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("Enum has create method without String as first parameter:\n");
                    sb2.append("  Enum: ").append(classType.getDescriptor()).append("\n");
                    sb2.append("  Target: ").append(mtd.name).append(mtd.desc).append("\n");
                    LOGGER.error(LogUtils.FATAL_MARKER, sb2.toString());
                }
                throw new IllegalStateException("Enum has create method without String as first parameter: " + mtd.name + mtd.desc);
            }
            Type ret = Type.getReturnType((String)mtd.desc);
            if (!ret.equals((Object)classType)) {
                if (LOGGER.isErrorEnabled(LogUtils.FATAL_MARKER)) {
                    StringBuilder sb3 = new StringBuilder();
                    sb3.append("Enum has create method with incorrect return type:\n");
                    sb3.append("  Enum: ").append(classType.getDescriptor()).append("\n");
                    sb3.append("  Target: ").append(mtd.name).append(mtd.desc).append("\n");
                    sb3.append("  Found: ").append(ret.getClassName()).append(", Expected: ").append(classType.getClassName());
                    LOGGER.error(LogUtils.FATAL_MARKER, sb3.toString());
                }
                throw new IllegalStateException("Enum has create method with incorrect return type: " + mtd.name + mtd.desc);
            }
            Type[] ctrArgs = new Type[args.length + 1];
            ctrArgs[0] = STRING;
            ctrArgs[1] = Type.INT_TYPE;
            System.arraycopy(args, 1, ctrArgs, 2, args.length - 1);
            String desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])ctrArgs);
            MethodNode ctr = classNode.methods.stream().filter(m -> m.name.equals("<init>") && m.desc.equals(desc)).findFirst().orElse(null);
            if (ctr == null) {
                if (LOGGER.isErrorEnabled(LogUtils.FATAL_MARKER)) {
                    sb = new StringBuilder();
                    sb.append("Enum has create method with no matching constructor:\n");
                    sb.append("  Enum: ").append(classType.getDescriptor()).append("\n");
                    sb.append("  Candidate: ").append(mtd.desc).append("\n");
                    sb.append("  Target: ").append(desc).append("\n");
                    classNode.methods.stream().filter(m -> m.name.equals("<init>")).forEach(m -> sb.append("        : ").append(m.desc).append("\n"));
                    LOGGER.error(LogUtils.FATAL_MARKER, sb.toString());
                }
                throw new IllegalStateException("Enum has create method with no matching constructor: " + desc);
            }
            if (values == null) {
                if (LOGGER.isErrorEnabled(LogUtils.FATAL_MARKER)) {
                    sb = new StringBuilder();
                    sb.append("Enum has create method but we could not find $VALUES. Found:\n");
                    classNode.fields.stream().filter(f -> (f.access & 8) != 0).forEach(m -> sb.append("  ").append(m.name).append(" ").append(m.desc).append("\n"));
                    LOGGER.error(LogUtils.FATAL_MARKER, sb.toString());
                }
                throw new IllegalStateException("Enum has create method but we could not find $VALUES");
            }
            values.access &= values.access & 0xFFFFFFEF;
            mtd.access |= 0x20;
            mtd.instructions.clear();
            mtd.localVariables.clear();
            if (mtd.tryCatchBlocks != null) {
                mtd.tryCatchBlocks.clear();
            }
            if (mtd.visibleLocalVariableAnnotations != null) {
                mtd.visibleLocalVariableAnnotations.clear();
            }
            if (mtd.invisibleLocalVariableAnnotations != null) {
                mtd.invisibleLocalVariableAnnotations.clear();
            }
            InstructionAdapter ins = new InstructionAdapter((MethodVisitor)mtd);
            int vars = 0;
            for (Type arg : args) {
                vars += arg.getSize();
            }
            Label for_start = new Label();
            Label for_condition = new Label();
            Label for_inc = new Label();
            ins.iconst(0);
            ins.store(++vars, Type.INT_TYPE);
            ins.goTo(for_condition);
            ins.mark(for_start);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.load(vars, Type.INT_TYPE);
            ins.aload(array);
            ins.invokevirtual(ENUM.getInternalName(), "name", NAME_DESC, false);
            ins.load(0, STRING);
            ins.invokevirtual(STRING.getInternalName(), "equalsIgnoreCase", EQUALS_DESC, false);
            ins.ifeq(for_inc);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.load(vars, Type.INT_TYPE);
            ins.aload(array);
            ins.areturn(classType);
            ins.mark(for_inc);
            ins.iinc(vars, 1);
            ins.mark(for_condition);
            ins.load(vars, Type.INT_TYPE);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.arraylength();
            ins.ificmplt(for_start);
            ++vars;
            ins.anew(classType);
            ins.dup();
            ins.load(0, STRING);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.arraylength();
            int idx = 1;
            for (int x = 1; x < args.length; ++x) {
                ins.load(idx, args[x]);
                idx += args[x].getSize();
            }
            ins.invokespecial(classType.getInternalName(), "<init>", desc, false);
            ins.store(vars, classType);
            ins.getstatic(classType.getInternalName(), values.name, values.desc);
            ins.load(vars, classType);
            ins.invokestatic(ARRAY_UTILS.getInternalName(), "add", ADD_DESC, false);
            ins.checkcast(array);
            ins.putstatic(classType.getInternalName(), values.name, values.desc);
            ins.visitLdcInsn((Object)classType);
            ins.invokestatic(UNSAFE_HACKS.getInternalName(), "cleanEnumCache", CLEAN_DESC, false);
            ins.load(vars, classType);
            ins.invokeinterface(MARKER_IFACE.getInternalName(), "init", "()V");
            ins.load(vars, classType);
            ins.areturn(classType);
        }
        return 2;
    }
}

