/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.StringSubstitutor;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import net.minecraftforge.forgespi.locating.ForgeFeature;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class ModInfo
extends Record
implements IModInfo,
IConfigurable {
    private final ModFileInfo getOwningFile;
    private final IConfigurable getConfig;
    private final String getModId;
    private final String getNamespace;
    private final ArtifactVersion getVersion;
    private final String getDisplayName;
    private final String getDescription;
    private final Optional<String> getLogoFile;
    private final boolean getLogoBlur;
    private final Optional<URL> getUpdateURL;
    private final Optional<URL> getModURL;
    private final Holder<List<? extends ModVersion>> dependencies;
    private final Holder<List<ForgeFeature.Bound>> forgeFeatures;
    private final Map<String, Object> getModProperties;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DefaultArtifactVersion DEFAULT_VERSION = new DefaultArtifactVersion("1");
    private static final Pattern VALID_MODID = Pattern.compile("^[a-z][a-z0-9_]{1,63}$");
    private static final Pattern VALID_NAMESPACE = Pattern.compile("^[a-z][a-z0-9_.-]{1,63}$");
    private static final Pattern VALID_VERSION = Pattern.compile("^\\d+.*");

    public ModInfo(ModFileInfo getOwningFile, IConfigurable getConfig, String getModId, String getNamespace, ArtifactVersion getVersion, String getDisplayName, String getDescription, Optional<String> getLogoFile, boolean getLogoBlur, Optional<URL> getUpdateURL, Optional<URL> getModURL, Holder<List<? extends ModVersion>> dependencies, Holder<List<ForgeFeature.Bound>> forgeFeatures, Map<String, Object> getModProperties) {
        this.getOwningFile = getOwningFile;
        this.getConfig = getConfig;
        this.getModId = getModId;
        this.getNamespace = getNamespace;
        this.getVersion = getVersion;
        this.getDisplayName = getDisplayName;
        this.getDescription = getDescription;
        this.getLogoFile = getLogoFile;
        this.getLogoBlur = getLogoBlur;
        this.getUpdateURL = getUpdateURL;
        this.getModURL = getModURL;
        this.dependencies = dependencies;
        this.forgeFeatures = forgeFeatures;
        this.getModProperties = getModProperties;
    }

    public static ModInfo of(ModFileInfo owningFile, IConfigurable config) {
        String modId = config.getConfigElement("modId").orElse(null);
        if (modId == null) {
            throw new InvalidModFileException("Missing modId", owningFile);
        }
        if (!VALID_MODID.matcher(modId).matches()) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Invalid modId found in file {} - {} does not match the standard: {}", new Object[]{owningFile.getFile().getFilePath(), modId, VALID_MODID.pattern()});
            throw new InvalidModFileException("Invalid modId found : " + modId, owningFile);
        }
        String namespace = config.getConfigElement("namespace").orElse(modId);
        if (!VALID_NAMESPACE.matcher(namespace).matches()) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Invalid override namespace found in file {} - {} does not match the standard: {}", new Object[]{owningFile.getFile().getFilePath(), namespace, VALID_NAMESPACE.pattern()});
            throw new InvalidModFileException("Invalid override namespace found : " + namespace, owningFile);
        }
        ArtifactVersion version = (ArtifactVersion)config.getConfigElement("version").map(s -> StringSubstitutor.replace(s, owningFile.getFile())).map(DefaultArtifactVersion::new).orElse(DEFAULT_VERSION);
        if (!VALID_VERSION.matcher(version.toString()).matches()) {
            throw new InvalidModFileException("Illegal version number specified " + String.valueOf(version), owningFile);
        }
        String displayName = config.getConfigElement("displayName").orElse(modId);
        String description = config.getConfigElement("description").orElse("MISSING DESCRIPTION").replace("\r\n", "\n").stripIndent();
        Optional<String> logoFile = Optional.ofNullable(config.getConfigElement("logoFile").orElseGet(() -> owningFile.getConfigElement("logoFile").orElse(null)));
        Boolean logoBlur = config.getConfigElement("logoBlur").orElse(null);
        if (logoBlur == null) {
            logoBlur = owningFile.getConfigElement("logoBlur").orElse(true);
        }
        Optional<URL> updateJSONURL = config.getConfigElement("updateJSONURL").map(StringUtils::toURL);
        Optional<URL> modUrl = config.getConfigElement("modUrl").map(StringUtils::toURL);
        List dependencies = Collections.emptyList();
        List forgeFeatures = Collections.emptyList();
        Map<String, Object> modProperties = owningFile.getConfigElement("modproperties", modId).map(Collections::unmodifiableMap).orElse(Collections.emptyMap());
        return new ModInfo(owningFile, config, modId, namespace, version, displayName, description, logoFile, logoBlur, updateJSONURL, modUrl, new Holder<List<? extends ModVersion>>(dependencies), new Holder<List<ForgeFeature.Bound>>(forgeFeatures), modProperties).setupDependencies().setupForgeFeatures();
    }

    private ModInfo setupDependencies() {
        List<? extends IConfigurable> deps = this.getOwningFile.getConfigList("dependencies", this.getModId);
        if (deps == null || deps.isEmpty()) {
            this.dependencies.value = Collections.emptyList();
            return this;
        }
        ModVersion[] tmp = new ModVersion[deps.size()];
        for (int i = 0; i < deps.size(); ++i) {
            tmp[i] = ModVersion.of(this, deps.get(i));
        }
        this.dependencies.value = List.of(tmp);
        return this;
    }

    private ModInfo setupForgeFeatures() {
        Map feats = this.getOwningFile.getConfigElement("features", this.getModId).orElse(null);
        if (feats == null) {
            this.forgeFeatures.value = Collections.emptyList();
            return this;
        }
        ArrayList<ForgeFeature.Bound> tmp = new ArrayList<ForgeFeature.Bound>();
        for (Map.Entry entry : feats.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof String)) {
                throw new InvalidModFileException("Invalid feature bound {" + String.valueOf(entry.getValue()) + "} for key {" + (String)entry.getKey() + "} only strings are accepted", this.getOwningFile);
            }
            String val = (String)v;
            tmp.add(new ForgeFeature.Bound((String)entry.getKey(), val, (IModInfo)this));
        }
        this.forgeFeatures.value = List.copyOf(tmp);
        return this;
    }

    public <T> Optional<T> getConfigElement(String key) {
        return this.getConfig.getConfigElement(key);
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.getConfig.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return null;
    }

    public List<? extends IModInfo.ModVersion> getDependencies() {
        return (List)this.dependencies.value;
    }

    public List<? extends ForgeFeature.Bound> getForgeFeatures() {
        return (List)this.forgeFeatures.value;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ModInfo.class, "getOwningFile;getConfig;getModId;getNamespace;getVersion;getDisplayName;getDescription;getLogoFile;getLogoBlur;getUpdateURL;getModURL;dependencies;forgeFeatures;getModProperties", "getOwningFile", "getConfig", "getModId", "getNamespace", "getVersion", "getDisplayName", "getDescription", "getLogoFile", "getLogoBlur", "getUpdateURL", "getModURL", "dependencies", "forgeFeatures", "getModProperties"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ModInfo.class, "getOwningFile;getConfig;getModId;getNamespace;getVersion;getDisplayName;getDescription;getLogoFile;getLogoBlur;getUpdateURL;getModURL;dependencies;forgeFeatures;getModProperties", "getOwningFile", "getConfig", "getModId", "getNamespace", "getVersion", "getDisplayName", "getDescription", "getLogoFile", "getLogoBlur", "getUpdateURL", "getModURL", "dependencies", "forgeFeatures", "getModProperties"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ModInfo.class, "getOwningFile;getConfig;getModId;getNamespace;getVersion;getDisplayName;getDescription;getLogoFile;getLogoBlur;getUpdateURL;getModURL;dependencies;forgeFeatures;getModProperties", "getOwningFile", "getConfig", "getModId", "getNamespace", "getVersion", "getDisplayName", "getDescription", "getLogoFile", "getLogoBlur", "getUpdateURL", "getModURL", "dependencies", "forgeFeatures", "getModProperties"}, this, o);
    }

    public ModFileInfo getOwningFile() {
        return this.getOwningFile;
    }

    public IConfigurable getConfig() {
        return this.getConfig;
    }

    public String getModId() {
        return this.getModId;
    }

    public String getNamespace() {
        return this.getNamespace;
    }

    public ArtifactVersion getVersion() {
        return this.getVersion;
    }

    public String getDisplayName() {
        return this.getDisplayName;
    }

    public String getDescription() {
        return this.getDescription;
    }

    public Optional<String> getLogoFile() {
        return this.getLogoFile;
    }

    public boolean getLogoBlur() {
        return this.getLogoBlur;
    }

    public Optional<URL> getUpdateURL() {
        return this.getUpdateURL;
    }

    public Optional<URL> getModURL() {
        return this.getModURL;
    }

    public Holder<List<? extends ModVersion>> dependencies() {
        return this.dependencies;
    }

    public Holder<List<ForgeFeature.Bound>> forgeFeatures() {
        return this.forgeFeatures;
    }

    public Map<String, Object> getModProperties() {
        return this.getModProperties;
    }

    private static final class Holder<T> {
        private T value;

        public Holder(T value) {
            this.value = value;
        }
    }

    private record ModVersion(Holder<IModInfo> owner, String getModId, VersionRange getVersionRange, boolean isMandatory, IModInfo.Ordering getOrdering, IModInfo.DependencySide getSide, Optional<URL> getReferralURL) implements IModInfo.ModVersion
    {
        public static ModVersion of(IModInfo owner, IConfigurable config) {
            boolean mandatory;
            Optional mandatoryValue;
            Map fileProps;
            String modId = config.getConfigElement("modId").orElse(null);
            if (modId == null) {
                throw new InvalidModFileException("Missing required field modid in dependency", owner.getOwningFile());
            }
            if (modId.equals("forge") && !(fileProps = owner.getOwningFile().getFileProperties()).isEmpty() && fileProps.containsKey("__FORGE__not_a_forge_mod")) {
                fileProps.remove("__FORGE__not_a_forge_mod");
            }
            if ((mandatoryValue = config.getConfigElement("mandatory")).isPresent()) {
                mandatory = (Boolean)mandatoryValue.get();
            } else if (owner.getOwningFile().getFileProperties().containsKey("__FORGE__not_a_forge_mod")) {
                mandatory = true;
            } else {
                throw new InvalidModFileException("Missing required field mandatory in dependency", owner.getOwningFile());
            }
            VersionRange versionRange = config.getConfigElement("versionRange").map(MavenVersionAdapter::createFromVersionSpec).orElse(IModInfo.UNBOUNDED);
            IModInfo.Ordering ordering = config.getConfigElement("ordering").map(IModInfo.Ordering::valueOf).orElse(IModInfo.Ordering.NONE);
            IModInfo.DependencySide side = config.getConfigElement("side").map(IModInfo.DependencySide::valueOf).orElse(IModInfo.DependencySide.BOTH);
            Optional<URL> referralUrl = config.getConfigElement("referralUrl").map(StringUtils::toURL);
            return new ModVersion(new Holder<IModInfo>(owner), modId, versionRange, mandatory, ordering, side, referralUrl);
        }

        public IModInfo getOwner() {
            return (IModInfo)this.owner.value;
        }

        public void setOwner(IModInfo newOwner) {
            this.owner.value = newOwner;
        }
    }
}

