/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.bootstrap;

import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.bootstrap.api.BootstrapClasspathModifier;
import net.minecraftforge.bootstrap.api.BootstrapEntryPoint;
import net.minecraftforge.securemodules.SecureModuleClassLoader;
import net.minecraftforge.securemodules.SecureModuleFinder;
import net.minecraftforge.unsafe.UnsafeHacks;

public class Bootstrap {
    static final boolean DEBUG = Boolean.getBoolean("bsl.debug");

    static void log(String message) {
        System.out.println(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(String ... args) throws Exception {
        List<Path> raw = Bootstrap.findAllClassPathEntries();
        ArrayList<Path[]> classpath = new ArrayList<Path[]>(raw.size());
        ArrayList<Path[]> processed = new ArrayList<Path[]>(raw.size());
        for (Path path : raw) {
            classpath.add(new Path[]{path});
            processed.add(new Path[]{path});
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        boolean modified = false;
        for (BootstrapClasspathModifier bootstrapClasspathModifier : ServiceLoader.load(BootstrapClasspathModifier.class, cl)) {
            if (DEBUG) {
                Bootstrap.log("Calling Service: " + bootstrapClasspathModifier.name());
            }
            modified |= bootstrapClasspathModifier.process(processed);
        }
        if (!modified) {
            this.bootstrapMain(args, classpath);
            return;
        }
        if (modified) {
            if (DEBUG) {
                Bootstrap.log("Services modified the classpath, building new classloader:");
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Path[] paths : processed) {
                if (paths == null) continue;
                if (paths.length == 1) {
                    URL url = paths[0].toUri().toURL();
                    urls.add(url);
                    if (!DEBUG) continue;
                    Bootstrap.log("    " + url);
                    continue;
                }
                Path[] ordered = new Path[paths.length];
                for (int x = 0; x < paths.length; ++x) {
                    ordered[x] = paths[paths.length - x - 1];
                }
                SecureJar jar = SecureJar.from((Path[])ordered);
                URL url = jar.getRootPath().toUri().toURL();
                urls.add(url);
                if (!DEBUG) continue;
                Bootstrap.log("    " + url);
                for (Path path : paths) {
                    Bootstrap.log("        " + path.toUri().toURL());
                }
            }
            ClassLoader classLoader = ClassLoader.getPlatformClassLoader();
            URLClassLoader newCL = new URLClassLoader("CLEANED-BOOTSTRAP", (URL[])urls.toArray(URL[]::new), classLoader);
            try {
                Thread.currentThread().setContextClassLoader(newCL);
                Class<?> self = Class.forName(this.getClass().getName(), false, newCL);
                Object inst = self.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method main = Bootstrap.findMethod(self, "bootstrapMain", String[].class, List.class);
                if (main == null) {
                    throw new IllegalStateException("Could not find \"bootstrapMain(String[], List<Path[]>))\" on " + self.getName());
                }
                UnsafeHacks.setAccessible((AccessibleObject)main);
                main.invoke(inst, args, processed);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    protected void bootstrapMain(String[] args, List<Path[]> classpath) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            List<SecureJar> boot = this.selectBootModules(classpath);
            SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])((SecureJar[])boot.toArray(SecureJar[]::new)));
            List<String> targets = boot.stream().map(SecureJar::name).toList();
            Configuration cfg = ModuleLayer.boot().configuration().resolve((ModuleFinder)finder, ModuleFinder.ofSystem(), targets);
            ModuleLayer layer = ModuleLayer.boot().defineModulesWithOneLoader(cfg, cl);
            Module bootstrap = layer.findModule("net.minecraftforge.bootstrap").get();
            ClassLoader moduleCl = bootstrap.getClassLoader();
            Class<?> self = Class.forName(this.getClass().getName(), false, moduleCl);
            Object inst = self.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method moduleMain = Bootstrap.findMethod(self, "moduleMain", String[].class, List.class);
            if (moduleMain == null) {
                throw new IllegalStateException("Could not find \"moduleMain(String[], List<Path[]>))\" on " + self.getName());
            }
            UnsafeHacks.setAccessible((AccessibleObject)moduleMain);
            moduleMain.invoke(inst, args, classpath);
        }
        catch (Exception e) {
            Bootstrap.sneak(e);
        }
    }

    protected List<SecureJar> selectBootModules(List<Path[]> classpath) {
        ArrayList<SecureJar> ret = new ArrayList<SecureJar>();
        Set<String> bootLibraries = Set.of("cpw.mods.securejarhandler", "net.minecraftforge.unsafe", "net.minecraftforge.bootstrap", "net.minecraftforge.bootstrap.api", "org.objectweb.asm", "org.objectweb.asm.tree");
        for (Path[] paths : classpath) {
            SecureJar jar = this.secureJar(paths);
            if (!bootLibraries.contains(jar.moduleDataProvider().name())) continue;
            ret.add(jar);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moduleMain(String[] args, List<Path[]> classpath) throws Exception {
        ModuleLayer bootlayer = this.getClass().getModule().getLayer();
        List<SecureJar> secure = this.selectRuntimeModules(classpath);
        SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])((SecureJar[])secure.toArray(SecureJar[]::new)));
        List<String> targets = secure.stream().map(SecureJar::name).toList();
        Configuration cfg = bootlayer.configuration().resolveAndBind((ModuleFinder)finder, ModuleFinder.ofSystem(), targets);
        List<ModuleLayer> parent = List.of(ModuleLayer.boot(), bootlayer);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        SecureModuleClassLoader cl = new SecureModuleClassLoader("SECURE-BOOTSTRAP", null, cfg, parent, oldcl == null ? List.of() : List.of(oldcl));
        ModuleLayer layer = bootlayer.defineModules(cfg, module -> cl);
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            List<ServiceLoader.Provider<BootstrapEntryPoint>> services = ServiceLoader.load(layer, BootstrapEntryPoint.class).stream().toList();
            if (services.isEmpty()) {
                throw new IllegalStateException("Could not find any " + BootstrapEntryPoint.class.getName() + " service providers");
            }
            if (services.size() > 1) {
                throw new IllegalStateException("Found multiple " + BootstrapEntryPoint.class.getName() + " service providers: " + services.stream().map(p -> ((BootstrapEntryPoint)p.get()).name()).collect(Collectors.joining(", ")));
            }
            BootstrapEntryPoint loader = services.get(0).get();
            if (DEBUG) {
                Bootstrap.log("Starting: " + loader.getClass().getModule().getName() + "/" + loader.name());
            }
            loader.main(args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    protected List<SecureJar> selectRuntimeModules(List<Path[]> classpath) {
        ArrayList<SecureJar> jars = new ArrayList<SecureJar>();
        for (Path[] paths : classpath) {
            jars.add(this.secureJar(paths));
        }
        ArrayList<SecureJar> ret = new ArrayList<SecureJar>();
        ModuleLayer bootlayer = this.getClass().getModule().getLayer();
        int width = jars.stream().mapToInt(j -> j.moduleDataProvider().name().length()).max().orElse(0) + 1;
        if (DEBUG) {
            Bootstrap.log("Found classpath:");
        }
        for (int x = 0; x < classpath.size(); ++x) {
            SecureJar jar = (SecureJar)jars.get(x);
            String name = jar.moduleDataProvider().name();
            Path[] paths = classpath.get(x);
            if (bootlayer.findModule(name).isPresent()) {
                Bootstrap.log("  Bootstrap: ", width, name, paths);
                continue;
            }
            Bootstrap.log("  Module:    ", width, name, paths);
            ret.add(jar);
        }
        return ret;
    }

    protected static String pad(int width, String str) {
        return str + " ".repeat(width - str.length());
    }

    protected static void log(String prefix, int width, String name, Path[] paths) {
        if (!DEBUG) {
            return;
        }
        Bootstrap.log(prefix + Bootstrap.pad(width, name) + paths[paths.length - 1]);
        prefix = " ".repeat(width + prefix.length());
        for (int x = paths.length - 2; x >= 0; --x) {
            Bootstrap.log(prefix + paths[x]);
        }
    }

    protected SecureJar secureJar(Path[] paths) {
        Path[] ordered = paths;
        if (paths.length > 1) {
            ordered = new Path[paths.length];
            for (int x = 0; x < paths.length; ++x) {
                ordered[x] = paths[paths.length - x - 1];
            }
        }
        return SecureJar.from((Path[])ordered);
    }

    private static Method findMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        try {
            return cls.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (cls.getSuperclass() != null) {
                return Bootstrap.findMethod(cls.getSuperclass(), name, parameterTypes);
            }
            return null;
        }
    }

    private static List<Path> findAllClassPathEntries() throws IOException {
        String[] parts = System.getProperty("java.class.path").split(File.pathSeparator);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String part : parts) {
            Path path = new File(part).getCanonicalFile().toPath();
            if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) && Files.list(path).findAny().isEmpty()) continue;
            paths.add(path);
        }
        return paths;
    }

    private static <E extends Throwable, R> R sneak(Exception exception) throws E {
        throw exception;
    }
}

