/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.Cache;

class CacheConcurrent<K, V>
implements Cache<K, V> {
    private Object lock = new Object();
    private final Map<K, V> map = new ConcurrentHashMap(32);

    CacheConcurrent() {
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I> V computeIfAbsent(K key, Supplier<I> factory, Function<I, V> finalizer) {
        V ret = this.get(key);
        if (ret != null) {
            return ret;
        }
        I intermediate = factory.get();
        Object object = this.lock;
        synchronized (object) {
            ret = this.map.get(key);
            if (ret == null) {
                ret = finalizer.apply(intermediate);
                this.map.put(key, ret);
            }
            return ret;
        }
    }
}

