/*
 * Decompiled with CFR 0.152.
 */
package com.nothome.delta.text;

import com.nothome.delta.text.DiffTextWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class GDiffTextWriter
implements DiffTextWriter {
    public static final char LF = '\n';
    public static final char COPY = 'y';
    public static final char DATA = 'i';
    public static final char COMMA = ',';
    static final String GDT = "gdt";
    private CharArrayWriter caw = new CharArrayWriter();
    private Writer w = null;
    public static final int CHUNK_SIZE = 32768;

    public GDiffTextWriter(Writer w) throws IOException {
        if (w == null) {
            throw new NullPointerException("w");
        }
        this.w = w;
        w.write(GDT);
        w.write(10);
    }

    private String d(int i) {
        return Integer.toHexString(i);
    }

    public void addCopy(int offset, int length) throws IOException {
        this.writeBuf();
        this.w.write(121);
        this.w.write(this.d(offset));
        this.w.write(44);
        this.w.write(this.d(length));
        this.w.write(10);
    }

    public void addData(char c) throws IOException {
        this.caw.append(c);
        if (this.caw.size() > 32768) {
            this.flush();
        }
    }

    private void writeBuf() throws IOException {
        if (this.caw.size() == 0) {
            return;
        }
        this.w.write(105);
        this.w.write(this.d(this.caw.size()));
        this.w.write(10);
        this.caw.writeTo(this.w);
        this.caw.reset();
        this.w.write(10);
    }

    public void flush() throws IOException {
        this.writeBuf();
        this.w.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.w.close();
    }
}

