/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;

public class ModList {
    private static ModList INSTANCE;
    private final List<IModFileInfo> modFiles;
    private final List<IModInfo> sortedList;
    private final Map<String, ModFileInfo> fileById;
    private List<ModContainer> mods;
    private Map<String, ModContainer> indexedMods;
    private List<ModFileScanData> modFileScanData;
    private List<ModContainer> sortedContainers;

    private ModList(List<ModFile> modFiles, List<ModInfo> sortedList) {
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = sortedList.stream().map(ModInfo.class::cast).collect(Collectors.toList());
        this.fileById = this.modFiles.stream().map(IModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        CrashReportCallables.registerCrashCallable("Mod List", this::crashReport);
    }

    private String getModContainerState(String modId) {
        return this.getModContainerById(modId).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE");
    }

    private String fileToLine(IModFile mf) {
        IModInfo mainMod = (IModInfo)mf.getModInfos().getFirst();
        return String.format(Locale.ENGLISH, "%-50.50s|%-30.30s|%-30.30s|%-20.20s|%-10.10s|Manifest: %s", mf.getFileName(), mainMod.getDisplayName(), mainMod.getModId(), mainMod.getVersion(), this.getModContainerState(mainMod.getModId()), ((ModFileInfo)mf.getModFileInfo()).getCodeSigningFingerprint().orElse("NOSIGNATURE"));
    }

    private String crashReport() {
        return "\n" + this.applyForEachModFile(this::fileToLine).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    public static ModList of(List<ModFile> modFiles, List<ModInfo> sortedList) {
        INSTANCE = new ModList(modFiles, sortedList);
        return INSTANCE;
    }

    public static ModList get() {
        return INSTANCE;
    }

    public List<IModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public IModFileInfo getModFileById(String modid) {
        return (IModFileInfo)this.fileById.get(modid);
    }

    <T extends Event> Function<Executor, CompletableFuture<Void>> futureVisitor(IModStateTransition.EventGenerator<T> eventGenerator, ProgressMeter progressBar, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> stateChange) {
        return executor -> ModList.gather(this.mods.stream().map(mod -> ModContainer.buildTransitionHandler(mod, eventGenerator, progressBar, stateChange, executor)).toList()).thenComposeAsync(ModList::completableFutureFromExceptionList, (Executor)executor);
    }

    static CompletionStage<Void> completableFutureFromExceptionList(List<? extends Map.Entry<?, Throwable>> t) {
        if (t.stream().noneMatch(e -> e.getValue() != null)) {
            return CompletableFuture.completedFuture(null);
        }
        List<Throwable> throwables = t.stream().filter(e -> e.getValue() != null).map(Map.Entry::getValue).toList();
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        RuntimeException accumulator = new RuntimeException();
        cf.completeExceptionally(accumulator);
        for (Throwable exception : throwables) {
            if (exception instanceof CompletionException) {
                exception = exception.getCause();
            }
            if (exception.getSuppressed().length != 0) {
                for (Throwable throwable : exception.getSuppressed()) {
                    accumulator.addSuppressed(throwable);
                }
                continue;
            }
            accumulator.addSuppressed(exception);
        }
        return cf;
    }

    static <V> CompletableFuture<List<Map.Entry<V, Throwable>>> gather(List<? extends CompletableFuture<? extends V>> futures) {
        ArrayList list = new ArrayList(futures.size());
        CompletableFuture[] results = new CompletableFuture[futures.size()];
        for (CompletableFuture<V> future : futures) {
            int i = list.size();
            list.add(null);
            results[i] = future.whenComplete((result, exception) -> list.set(i, new AbstractMap.SimpleImmutableEntry<Object, Throwable>(result, (Throwable)exception)));
        }
        return ((CompletableFuture)CompletableFuture.allOf(results).handle((r, th) -> null)).thenApply(res -> list);
    }

    void setLoadedMods(List<ModContainer> modContainers) {
        this.mods = modContainers;
        this.sortedContainers = modContainers.stream().sorted(Comparator.comparingInt(c -> this.sortedList.indexOf(c.getModInfo()))).toList();
        this.indexedMods = modContainers.stream().collect(Collectors.toMap(ModContainer::getModId, Function.identity()));
    }

    public <T> Optional<T> getModObjectById(String modId) {
        return this.getModContainerById(modId).map(ModContainer::getMod).map(o -> o);
    }

    public Optional<? extends ModContainer> getModContainerById(String modId) {
        return Optional.ofNullable(this.indexedMods.get(modId));
    }

    public Optional<? extends ModContainer> getModContainerByObject(Object obj) {
        return this.mods.stream().filter(mc -> mc.getMod() == obj).findFirst();
    }

    public List<IModInfo> getMods() {
        return this.sortedList;
    }

    public boolean isLoaded(String modTarget) {
        return this.indexedMods.containsKey(modTarget);
    }

    public int size() {
        return this.mods.size();
    }

    public List<ModFileScanData> getAllScanData() {
        if (this.modFileScanData == null) {
            this.modFileScanData = this.sortedList.stream().map(IModInfo::getOwningFile).filter(Objects::nonNull).map(IModFileInfo::getFile).distinct().map(IModFile::getScanResult).collect(Collectors.toList());
        }
        return this.modFileScanData;
    }

    public void forEachModFile(Consumer<IModFile> fileConsumer) {
        this.modFiles.stream().map(IModFileInfo::getFile).forEach(fileConsumer);
    }

    public <T> Stream<T> applyForEachModFile(Function<IModFile, T> function) {
        return this.modFiles.stream().map(IModFileInfo::getFile).map(function);
    }

    public void forEachModContainer(BiConsumer<String, ModContainer> modContainerConsumer) {
        this.indexedMods.forEach(modContainerConsumer);
    }

    public void forEachModInOrder(Consumer<ModContainer> containerConsumer) {
        this.sortedContainers.forEach(containerConsumer);
    }

    public <T> Stream<T> applyForEachModContainer(Function<ModContainer, T> function) {
        return this.indexedMods.values().stream().map(function);
    }

    private static class UncaughtModLoadingException
    extends ModLoadingException {
        public UncaughtModLoadingException(ModLoadingStage stage, Throwable originalException) {
            super(null, stage, "fml.modloading.uncaughterror", originalException, new Object[0]);
        }
    }
}

