/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.javafmlmod;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutomaticEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(Mod.EventBusSubscriber.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);
    private static final Type ONLY_IN_TYPE = Type.getType(OnlyIn.class);

    public static void inject(ModContainer mod, ModFileScanData scanData, ClassLoader loader) {
        if (scanData == null) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List<ModFileScanData.AnnotationData> targets = scanData.getAnnotations().stream().filter(data -> AUTO_SUBSCRIBER.equals((Object)data.annotationType())).toList();
        Set onlyIns = FMLEnvironment.production ? Collections.emptySet() : scanData.getAnnotations().stream().filter(data -> ONLY_IN_TYPE.equals((Object)data.annotationType())).map(data -> data.clazz().getClassName()).collect(Collectors.toSet());
        Map<String, String> modids = scanData.getAnnotations().stream().filter(data -> MOD_TYPE.equals((Object)data.annotationType())).collect(Collectors.toMap(a -> a.clazz().getClassName(), a -> (String)a.annotationData().get("value")));
        List<ModFileScanData.EnumData> defaultSides = List.of(new ModFileScanData.EnumData(null, "CLIENT"), new ModFileScanData.EnumData(null, "DEDICATED_SERVER"));
        ModFileScanData.EnumData defaultBus = new ModFileScanData.EnumData(null, "FORGE");
        for (ModFileScanData.AnnotationData data2 : targets) {
            if (!FMLEnvironment.production && onlyIns.contains(data2.clazz().getClassName())) {
                throw new RuntimeException("Found @OnlyIn on @EventBusSubscriber class " + data2.clazz().getClassName() + " - this is not allowed as it causes crashes. Remove the OnlyIn and set value=Dist.CLIENT in the EventBusSubscriber annotation instead");
            }
            String modId = modids.getOrDefault(data2.clazz().getClassName(), mod.getModId());
            modId = AutomaticEventSubscriber.value(data2, "modid", modId);
            List<ModFileScanData.EnumData> sidesValue = AutomaticEventSubscriber.value(data2, "value", defaultSides);
            Set sides = sidesValue.stream().map(ModFileScanData.EnumData::value).map(Dist::valueOf).collect(Collectors.toSet());
            String busName = AutomaticEventSubscriber.value(data2, "bus", defaultBus).value();
            Mod.EventBusSubscriber.Bus busTarget = Mod.EventBusSubscriber.Bus.valueOf(busName);
            if (!Objects.equals(mod.getModId(), modId) || !sides.contains(FMLEnvironment.dist)) continue;
            try {
                LOGGER.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)data2.clazz().getClassName(), (Object)busTarget);
                busTarget.bus().get().register(Class.forName(data2.clazz().getClassName(), true, loader));
            }
            catch (ClassNotFoundException e) {
                LOGGER.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)data2.clazz(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static <R> R value(ModFileScanData.AnnotationData data, String key, R value) {
        return data.annotationData().getOrDefault(key, value);
    }
}

