/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ItemPredicate(Optional<HolderSet<Item>> items, MinMaxBounds.Ints count, DataComponentPredicate components, Map<ItemSubPredicate.Type<?>, ItemSubPredicate> subPredicates) implements Predicate<ItemStack>
{
    public static final Codec<ItemPredicate> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)RegistryCodecs.homogeneousList(Registries.ITEM).optionalFieldOf("items").forGetter(ItemPredicate::items), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("count", (Object)MinMaxBounds.Ints.ANY).forGetter(ItemPredicate::count), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(ItemPredicate::components), (App)ItemSubPredicate.CODEC.optionalFieldOf("predicates", Map.of()).forGetter(ItemPredicate::subPredicates)).apply((Applicative)$$0, ItemPredicate::new));

    @Override
    public boolean test(ItemStack $$0) {
        if (this.items.isPresent() && !$$0.is(this.items.get())) {
            return false;
        }
        if (!this.count.matches($$0.getCount())) {
            return false;
        }
        if (!this.components.test($$0)) {
            return false;
        }
        for (ItemSubPredicate $$1 : this.subPredicates.values()) {
            if ($$1.matches($$0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ItemStack)object);
    }

    public static class Builder {
        private Optional<HolderSet<Item>> items = Optional.empty();
        private MinMaxBounds.Ints count = MinMaxBounds.Ints.ANY;
        private DataComponentPredicate components = DataComponentPredicate.EMPTY;
        private final ImmutableMap.Builder<ItemSubPredicate.Type<?>, ItemSubPredicate> subPredicates = ImmutableMap.builder();

        private Builder() {
        }

        public static Builder item() {
            return new Builder();
        }

        public Builder of(ItemLike ... $$02) {
            this.items = Optional.of(HolderSet.direct($$0 -> $$0.asItem().builtInRegistryHolder(), $$02));
            return this;
        }

        public Builder of(TagKey<Item> $$0) {
            this.items = Optional.of(BuiltInRegistries.ITEM.getOrCreateTag($$0));
            return this;
        }

        public Builder withCount(MinMaxBounds.Ints $$0) {
            this.count = $$0;
            return this;
        }

        public <T extends ItemSubPredicate> Builder withSubPredicate(ItemSubPredicate.Type<T> $$0, T $$1) {
            this.subPredicates.put($$0, $$1);
            return this;
        }

        public Builder hasComponents(DataComponentPredicate $$0) {
            this.components = $$0;
            return this;
        }

        public ItemPredicate build() {
            return new ItemPredicate(this.items, this.count, this.components, (Map<ItemSubPredicate.Type<?>, ItemSubPredicate>)this.subPredicates.build());
        }
    }
}

