/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.slf4j.Logger;

public class BlockMath {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<Direction, Transformation> VANILLA_UV_TRANSFORM_LOCAL_TO_GLOBAL = Util.make(Maps.newEnumMap(Direction.class), $$0 -> {
        $$0.put(Direction.SOUTH, Transformation.identity());
        $$0.put(Direction.EAST, new Transformation(null, new Quaternionf().rotateY(1.5707964f), null, null));
        $$0.put(Direction.WEST, new Transformation(null, new Quaternionf().rotateY(-1.5707964f), null, null));
        $$0.put(Direction.NORTH, new Transformation(null, new Quaternionf().rotateY((float)Math.PI), null, null));
        $$0.put(Direction.UP, new Transformation(null, new Quaternionf().rotateX(-1.5707964f), null, null));
        $$0.put(Direction.DOWN, new Transformation(null, new Quaternionf().rotateX(1.5707964f), null, null));
    });
    public static final Map<Direction, Transformation> VANILLA_UV_TRANSFORM_GLOBAL_TO_LOCAL = Util.make(Maps.newEnumMap(Direction.class), $$0 -> {
        for (Direction $$1 : Direction.values()) {
            $$0.put($$1, VANILLA_UV_TRANSFORM_LOCAL_TO_GLOBAL.get($$1).inverse());
        }
    });

    public static Transformation blockCenterToCorner(Transformation $$0) {
        Matrix4f $$1 = new Matrix4f().translation(0.5f, 0.5f, 0.5f);
        $$1.mul((Matrix4fc)$$0.getMatrix());
        $$1.translate(-0.5f, -0.5f, -0.5f);
        return new Transformation($$1);
    }

    public static Transformation blockCornerToCenter(Transformation $$0) {
        Matrix4f $$1 = new Matrix4f().translation(-0.5f, -0.5f, -0.5f);
        $$1.mul((Matrix4fc)$$0.getMatrix());
        $$1.translate(0.5f, 0.5f, 0.5f);
        return new Transformation($$1);
    }

    public static Transformation getUVLockTransform(Transformation $$0, Direction $$1) {
        Direction $$2 = Direction.rotate($$0.getMatrix(), $$1);
        Transformation $$3 = $$0.inverse();
        if ($$3 == null) {
            LOGGER.debug("Failed to invert transformation {}", (Object)$$0);
            return Transformation.identity();
        }
        Transformation $$4 = VANILLA_UV_TRANSFORM_GLOBAL_TO_LOCAL.get($$1).compose($$3).compose(VANILLA_UV_TRANSFORM_LOCAL_TO_GLOBAL.get($$2));
        return BlockMath.blockCenterToCorner($$4);
    }
}

