/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TrialChambersStructurePools {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("trial_chambers/chamber/end");
    public static final ResourceKey<StructureTemplatePool> HALLWAY_FALLBACK = Pools.createKey("trial_chambers/hallway/fallback");
    public static final ResourceKey<StructureTemplatePool> CHAMBER_CAP_FALLBACK = Pools.createKey("trial_chambers/chamber/entrance_cap");
    public static final List<PoolAliasBinding> ALIAS_BINDINGS = ImmutableList.builder().add((Object)PoolAliasBinding.randomGroup(SimpleWeightedRandomList.builder().add(List.of(PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/ranged"), TrialChambersStructurePools.spawner("ranged/skeleton")), PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/slow_ranged"), TrialChambersStructurePools.spawner("slow_ranged/skeleton")))).add(List.of(PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/ranged"), TrialChambersStructurePools.spawner("ranged/stray")), PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/slow_ranged"), TrialChambersStructurePools.spawner("slow_ranged/stray")))).add(List.of(PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/ranged"), TrialChambersStructurePools.spawner("ranged/poison_skeleton")), PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/slow_ranged"), TrialChambersStructurePools.spawner("slow_ranged/poison_skeleton")))).build())).add((Object)PoolAliasBinding.random(TrialChambersStructurePools.spawner("contents/melee"), SimpleWeightedRandomList.builder().add(TrialChambersStructurePools.spawner("melee/zombie")).add(TrialChambersStructurePools.spawner("melee/husk")).add(TrialChambersStructurePools.spawner("melee/spider")).build())).add((Object)PoolAliasBinding.random(TrialChambersStructurePools.spawner("contents/small_melee"), SimpleWeightedRandomList.builder().add(TrialChambersStructurePools.spawner("small_melee/slime")).add(TrialChambersStructurePools.spawner("small_melee/cave_spider")).add(TrialChambersStructurePools.spawner("small_melee/silverfish")).add(TrialChambersStructurePools.spawner("small_melee/baby_zombie")).build())).build();

    public static String spawner(String $$0) {
        return "trial_chambers/spawner/" + $$0;
    }

    public static void bootstrap(BootstrapContext<StructureTemplatePool> $$0) {
        HolderGetter<StructureTemplatePool> $$1 = $$0.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> $$2 = $$1.getOrThrow(Pools.EMPTY);
        Holder.Reference<StructureTemplatePool> $$3 = $$1.getOrThrow(HALLWAY_FALLBACK);
        Holder.Reference<StructureTemplatePool> $$4 = $$1.getOrThrow(CHAMBER_CAP_FALLBACK);
        HolderGetter<StructureProcessorList> $$5 = $$0.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> $$6 = $$5.getOrThrow(ProcessorLists.TRIAL_CHAMBERS_COPPER_BULB_DEGRADATION);
        $$0.register(START, new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/end_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/end_2", $$6), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chamber/entrance_cap", new StructureTemplatePool($$4, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/entrance_cap", $$6), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chambers/end", new StructureTemplatePool($$3, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted", $$6), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/corridor", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/second_plate"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/intersection/intersection_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/intersection/intersection_2", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/intersection/intersection_3", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/first_plate"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/entrance_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/entrance_2", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/entrance_3", $$6), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chamber/addon", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_stacked_walkway"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_stacked_walkway_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_corner_column"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/grate_bridge"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/hanging_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/short_grate_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/short_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/lower_staircase_down"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/walkway_with_bridge_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/c1_breeze"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chamber/assembly", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/full_column"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_1"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_2"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_3"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_4"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_5"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_6"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_7"), (Object)5), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/platform_1"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/spawner_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_1"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_3"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_4"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_5"), (Object)4), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/left_staircase_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/left_staircase_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/left_staircase_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/right_staircase_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/right_staircase_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/right_staircase_3"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chamber/eruption", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/center_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/breeze_slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/slice_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/slice_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_5"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chamber/slanted", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/center"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_5"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ominous_upper_arm_1"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chamber/pedestal", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/center_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_2"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_3"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_4"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_5"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/ominous_slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_4"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/corridor/slices", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_2", $$6), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_3", $$6), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_4", $$6), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_5", $$6), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_6", $$6), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_7", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_8", $$6), (Object)2)), StructureTemplatePool.Projection.RIGID));
        $$0.register(HALLWAY_FALLBACK, new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_thin"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber_thin"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/hallway", new StructureTemplatePool($$3, List.of(Pair.of(StructurePoolElement.single("trial_chambers/hallway/corridor_connector_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/upper_hallway_connector", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/lower_hallway_connector", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_1", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_2", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_4", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_8", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal", $$6), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber", $$6), (Object)10), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber_thin", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/cache_1", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/left_corner", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/right_corner", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/corner_staircase", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/corner_staircase_down", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/long_straight_staircase", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/long_straight_staircase_down", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/straight", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/straight_staircase", $$6), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/straight_staircase_down", $$6), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/corridors/addon/lower", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.empty(), (Object)8), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/staircase"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/wall"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/ladder_to_middle"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/arrow_dispenser"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/bridge_lower"), (Object)2)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/corridors/addon/middle", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.empty(), (Object)8), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/open_walkway"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/walled_walkway"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/corridors/addon/middle_upper", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.empty(), (Object)6), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/open_walkway_upper"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/chandelier_upper"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/decoration_upper"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/head_upper"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/reward_upper"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/atrium", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/bogged_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/breeze_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/spiral_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/spider_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/grand_staircase_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/grand_staircase_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/grand_staircase_3"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/decor", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.empty(), (Object)22), Pair.of(StructurePoolElement.single("trial_chambers/decor/empty_pot"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/decor/dead_bush_pot"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/decor/undecorated_pot"), (Object)10), Pair.of(StructurePoolElement.single("trial_chambers/decor/flow_pot"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/guster_pot"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/scrape_pot"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/barrel"), (Object)2)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/entrance", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/display_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/display_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/display_3"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/decor/chamber", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.empty(), (Object)4), Pair.of(StructurePoolElement.single("trial_chambers/decor/undecorated_pot"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/reward/all", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/reward/vault"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/reward/ominous_vault", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/reward/ominous_vault"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/reward/contents/default", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/reward/vault"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chests/supply", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chests/connectors/supply"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/chests/contents/supply", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chests/supply"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/ranged", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/ranged"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/slow_ranged", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/slow_ranged"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/melee", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/melee"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/small_melee", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/small_melee"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/breeze", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/breeze"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/all", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/ranged"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/melee"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/small_melee"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/spawner/contents/breeze", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/breeze/breeze"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register($$0, "trial_chambers/dispensers/chamber", new StructureTemplatePool($$2, List.of(Pair.of(StructurePoolElement.empty(), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/dispensers/chamber"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/dispensers/wall_dispenser"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/dispensers/floor_dispenser"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        PoolAliasBindings.registerTargetsAsPools($$0, $$2, ALIAS_BINDINGS);
    }
}

