/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;

public class ClientboundSetTimePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundSetTimePacket> STREAM_CODEC = Packet.codec(ClientboundSetTimePacket::write, ClientboundSetTimePacket::new);
    private final long gameTime;
    private final long dayTime;

    public ClientboundSetTimePacket(long $$0, long $$1, boolean $$2) {
        this.gameTime = $$0;
        long $$3 = $$1;
        if (!$$2 && ($$3 = -$$3) == 0L) {
            $$3 = -1L;
        }
        this.dayTime = $$3;
    }

    private ClientboundSetTimePacket(FriendlyByteBuf $$0) {
        this.gameTime = $$0.readLong();
        this.dayTime = $$0.readLong();
    }

    private void write(FriendlyByteBuf $$0) {
        $$0.writeLong(this.gameTime);
        $$0.writeLong(this.dayTime);
    }

    @Override
    public PacketType<ClientboundSetTimePacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_TIME;
    }

    @Override
    public void handle(ClientGamePacketListener $$0) {
        $$0.handleSetTime(this);
    }

    public long getGameTime() {
        return this.gameTime;
    }

    public long getDayTime() {
        return this.dayTime;
    }
}

