/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class CustomBossEvent
extends ServerBossEvent {
    private final ResourceLocation id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;

    public CustomBossEvent(ResourceLocation $$0, Component $$1) {
        super($$1, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.id = $$0;
        this.setProgress(0.0f);
    }

    public ResourceLocation getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(ServerPlayer $$0) {
        super.addPlayer($$0);
        this.players.add($$0.getUUID());
    }

    public void addOfflinePlayer(UUID $$0) {
        this.players.add($$0);
    }

    @Override
    public void removePlayer(ServerPlayer $$0) {
        super.removePlayer($$0);
        this.players.remove($$0.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int $$0) {
        this.value = $$0;
        this.setProgress(Mth.clamp((float)$$0 / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int $$0) {
        this.max = $$0;
        this.setProgress(Mth.clamp((float)this.value / (float)$$0, 0.0f, 1.0f));
    }

    public final Component getDisplayName() {
        return ComponentUtils.wrapInSquareBrackets(this.getName()).withStyle($$0 -> $$0.withColor(this.getColor().getFormatting()).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<ServerPlayer> $$0) {
        HashSet $$1 = Sets.newHashSet();
        HashSet $$2 = Sets.newHashSet();
        for (UUID $$3 : this.players) {
            boolean $$4 = false;
            for (ServerPlayer $$5 : $$0) {
                if (!$$5.getUUID().equals($$3)) continue;
                $$4 = true;
                break;
            }
            if ($$4) continue;
            $$1.add($$3);
        }
        for (ServerPlayer $$6 : $$0) {
            boolean $$7 = false;
            for (UUID $$8 : this.players) {
                if (!$$6.getUUID().equals($$8)) continue;
                $$7 = true;
                break;
            }
            if ($$7) continue;
            $$2.add($$6);
        }
        for (UUID $$9 : $$1) {
            for (ServerPlayer $$10 : this.getPlayers()) {
                if (!$$10.getUUID().equals($$9)) continue;
                this.removePlayer($$10);
                break;
            }
            this.players.remove($$9);
        }
        for (ServerPlayer $$11 : $$2) {
            this.addPlayer($$11);
        }
        return !$$1.isEmpty() || !$$2.isEmpty();
    }

    public CompoundTag save(HolderLookup.Provider $$0) {
        CompoundTag $$1 = new CompoundTag();
        $$1.putString("Name", Component.Serializer.toJson(this.name, $$0));
        $$1.putBoolean("Visible", this.isVisible());
        $$1.putInt("Value", this.value);
        $$1.putInt("Max", this.max);
        $$1.putString("Color", this.getColor().getName());
        $$1.putString("Overlay", this.getOverlay().getName());
        $$1.putBoolean("DarkenScreen", this.shouldDarkenScreen());
        $$1.putBoolean("PlayBossMusic", this.shouldPlayBossMusic());
        $$1.putBoolean("CreateWorldFog", this.shouldCreateWorldFog());
        ListTag $$2 = new ListTag();
        for (UUID $$3 : this.players) {
            $$2.add(NbtUtils.createUUID($$3));
        }
        $$1.put("Players", $$2);
        return $$1;
    }

    public static CustomBossEvent load(CompoundTag $$0, ResourceLocation $$1, HolderLookup.Provider $$2) {
        CustomBossEvent $$3 = new CustomBossEvent($$1, Component.Serializer.fromJson($$0.getString("Name"), $$2));
        $$3.setVisible($$0.getBoolean("Visible"));
        $$3.setValue($$0.getInt("Value"));
        $$3.setMax($$0.getInt("Max"));
        $$3.setColor(BossEvent.BossBarColor.byName($$0.getString("Color")));
        $$3.setOverlay(BossEvent.BossBarOverlay.byName($$0.getString("Overlay")));
        $$3.setDarkenScreen($$0.getBoolean("DarkenScreen"));
        $$3.setPlayBossMusic($$0.getBoolean("PlayBossMusic"));
        $$3.setCreateWorldFog($$0.getBoolean("CreateWorldFog"));
        ListTag $$4 = $$0.getList("Players", 11);
        for (Tag $$5 : $$4) {
            $$3.addOfflinePlayer(NbtUtils.loadUUID($$5));
        }
        return $$3;
    }

    public void onPlayerConnect(ServerPlayer $$0) {
        if (this.players.contains($$0.getUUID())) {
            this.addPlayer($$0);
        }
    }

    public void onPlayerDisconnect(ServerPlayer $$0) {
        super.removePlayer($$0);
    }
}

