/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;

public interface ResourceMetadata {
    public static final ResourceMetadata EMPTY = new ResourceMetadata(){

        @Override
        public <T> Optional<T> getSection(MetadataSectionSerializer<T> $$0) {
            return Optional.empty();
        }
    };
    public static final IoSupplier<ResourceMetadata> EMPTY_SUPPLIER = () -> EMPTY;

    public static ResourceMetadata fromJsonStream(InputStream $$0) throws IOException {
        try (BufferedReader $$1 = new BufferedReader(new InputStreamReader($$0, StandardCharsets.UTF_8));){
            final JsonObject $$2 = GsonHelper.parse($$1);
            ResourceMetadata resourceMetadata = new ResourceMetadata(){

                @Override
                public <T> Optional<T> getSection(MetadataSectionSerializer<T> $$0) {
                    String $$1 = $$0.getMetadataSectionName();
                    return $$2.has($$1) ? Optional.of($$0.fromJson(GsonHelper.getAsJsonObject($$2, $$1))) : Optional.empty();
                }
            };
            return resourceMetadata;
        }
    }

    public <T> Optional<T> getSection(MetadataSectionSerializer<T> var1);

    default public ResourceMetadata copySections(Collection<MetadataSectionSerializer<?>> $$0) {
        Builder $$1 = new Builder();
        for (MetadataSectionSerializer<?> $$2 : $$0) {
            this.copySection($$1, $$2);
        }
        return $$1.build();
    }

    private <T> void copySection(Builder $$0, MetadataSectionSerializer<T> $$1) {
        this.getSection($$1).ifPresent($$2 -> $$0.put($$1, $$2));
    }

    public static class Builder {
        private final ImmutableMap.Builder<MetadataSectionSerializer<?>, Object> map = ImmutableMap.builder();

        public <T> Builder put(MetadataSectionSerializer<T> $$0, T $$1) {
            this.map.put($$0, $$1);
            return this;
        }

        public ResourceMetadata build() {
            final ImmutableMap $$0 = this.map.build();
            if ($$0.isEmpty()) {
                return EMPTY;
            }
            return new ResourceMetadata(){

                @Override
                public <T> Optional<T> getSection(MetadataSectionSerializer<T> $$02) {
                    return Optional.ofNullable($$0.get($$02));
                }
            };
        }
    }
}

