/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.List;
import java.util.Optional;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import org.apache.commons.lang3.mutable.MutableBoolean;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S> Term<S> named(Atom<?> $$0) {
        return new Reference($$0);
    }

    public static <S, T> Term<S> marker(Atom<T> $$0, T $$1) {
        return new Marker($$0, $$1);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... $$0) {
        return new Sequence<S>(List.of($$0));
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... $$0) {
        return new Alternative<S>(List.of($$0));
    }

    public static <S> Term<S> optional(Term<S> $$0) {
        return new Maybe<S>($$0);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
                $$2.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public record Reference<S, T>(Atom<T> name) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
            Optional<T> $$3 = $$0.parse(this.name);
            if ($$3.isEmpty()) {
                return false;
            }
            $$1.put(this.name, $$3.get());
            return true;
        }
    }

    public record Marker<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
            $$1.put(this.name, this.value);
            return true;
        }
    }

    public record Sequence<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
            int $$3 = $$0.mark();
            for (Term<S> $$4 : this.elements) {
                if ($$4.parse($$0, $$1, $$2)) continue;
                $$0.restore($$3);
                return false;
            }
            return true;
        }
    }

    public record Alternative<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
            MutableBoolean $$3 = new MutableBoolean();
            Control $$4 = () -> ((MutableBoolean)$$3).setTrue();
            int $$5 = $$0.mark();
            for (Term<S> $$6 : this.elements) {
                if ($$3.isTrue()) break;
                Scope $$7 = new Scope();
                if ($$6.parse($$0, $$7, $$4)) {
                    $$1.putAll($$7);
                    return true;
                }
                $$0.restore($$5);
            }
            return false;
        }
    }

    public record Maybe<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> $$0, Scope $$1, Control $$2) {
            int $$3 = $$0.mark();
            if (!this.term.parse($$0, $$1, $$2)) {
                $$0.restore($$3);
            }
            return true;
        }
    }
}

