/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;

public class DamageSources {
    private final Registry<DamageType> damageTypes;
    private final DamageSource inFire;
    private final DamageSource campfire;
    private final DamageSource lightningBolt;
    private final DamageSource onFire;
    private final DamageSource lava;
    private final DamageSource hotFloor;
    private final DamageSource inWall;
    private final DamageSource cramming;
    private final DamageSource drown;
    private final DamageSource starve;
    private final DamageSource cactus;
    private final DamageSource fall;
    private final DamageSource flyIntoWall;
    private final DamageSource fellOutOfWorld;
    private final DamageSource generic;
    private final DamageSource magic;
    private final DamageSource wither;
    private final DamageSource dragonBreath;
    private final DamageSource dryOut;
    private final DamageSource sweetBerryBush;
    private final DamageSource freeze;
    private final DamageSource stalagmite;
    private final DamageSource outsideBorder;
    private final DamageSource genericKill;

    public DamageSources(RegistryAccess $$0) {
        this.damageTypes = $$0.registryOrThrow(Registries.DAMAGE_TYPE);
        this.inFire = this.source(DamageTypes.IN_FIRE);
        this.campfire = this.source(DamageTypes.CAMPFIRE);
        this.lightningBolt = this.source(DamageTypes.LIGHTNING_BOLT);
        this.onFire = this.source(DamageTypes.ON_FIRE);
        this.lava = this.source(DamageTypes.LAVA);
        this.hotFloor = this.source(DamageTypes.HOT_FLOOR);
        this.inWall = this.source(DamageTypes.IN_WALL);
        this.cramming = this.source(DamageTypes.CRAMMING);
        this.drown = this.source(DamageTypes.DROWN);
        this.starve = this.source(DamageTypes.STARVE);
        this.cactus = this.source(DamageTypes.CACTUS);
        this.fall = this.source(DamageTypes.FALL);
        this.flyIntoWall = this.source(DamageTypes.FLY_INTO_WALL);
        this.fellOutOfWorld = this.source(DamageTypes.FELL_OUT_OF_WORLD);
        this.generic = this.source(DamageTypes.GENERIC);
        this.magic = this.source(DamageTypes.MAGIC);
        this.wither = this.source(DamageTypes.WITHER);
        this.dragonBreath = this.source(DamageTypes.DRAGON_BREATH);
        this.dryOut = this.source(DamageTypes.DRY_OUT);
        this.sweetBerryBush = this.source(DamageTypes.SWEET_BERRY_BUSH);
        this.freeze = this.source(DamageTypes.FREEZE);
        this.stalagmite = this.source(DamageTypes.STALAGMITE);
        this.outsideBorder = this.source(DamageTypes.OUTSIDE_BORDER);
        this.genericKill = this.source(DamageTypes.GENERIC_KILL);
    }

    private DamageSource source(ResourceKey<DamageType> $$0) {
        return new DamageSource(this.damageTypes.getHolderOrThrow($$0));
    }

    private DamageSource source(ResourceKey<DamageType> $$0, @Nullable Entity $$1) {
        return new DamageSource(this.damageTypes.getHolderOrThrow($$0), $$1);
    }

    private DamageSource source(ResourceKey<DamageType> $$0, @Nullable Entity $$1, @Nullable Entity $$2) {
        return new DamageSource(this.damageTypes.getHolderOrThrow($$0), $$1, $$2);
    }

    public DamageSource inFire() {
        return this.inFire;
    }

    public DamageSource campfire() {
        return this.campfire;
    }

    public DamageSource lightningBolt() {
        return this.lightningBolt;
    }

    public DamageSource onFire() {
        return this.onFire;
    }

    public DamageSource lava() {
        return this.lava;
    }

    public DamageSource hotFloor() {
        return this.hotFloor;
    }

    public DamageSource inWall() {
        return this.inWall;
    }

    public DamageSource cramming() {
        return this.cramming;
    }

    public DamageSource drown() {
        return this.drown;
    }

    public DamageSource starve() {
        return this.starve;
    }

    public DamageSource cactus() {
        return this.cactus;
    }

    public DamageSource fall() {
        return this.fall;
    }

    public DamageSource flyIntoWall() {
        return this.flyIntoWall;
    }

    public DamageSource fellOutOfWorld() {
        return this.fellOutOfWorld;
    }

    public DamageSource generic() {
        return this.generic;
    }

    public DamageSource magic() {
        return this.magic;
    }

    public DamageSource wither() {
        return this.wither;
    }

    public DamageSource dragonBreath() {
        return this.dragonBreath;
    }

    public DamageSource dryOut() {
        return this.dryOut;
    }

    public DamageSource sweetBerryBush() {
        return this.sweetBerryBush;
    }

    public DamageSource freeze() {
        return this.freeze;
    }

    public DamageSource stalagmite() {
        return this.stalagmite;
    }

    public DamageSource fallingBlock(Entity $$0) {
        return this.source(DamageTypes.FALLING_BLOCK, $$0);
    }

    public DamageSource anvil(Entity $$0) {
        return this.source(DamageTypes.FALLING_ANVIL, $$0);
    }

    public DamageSource fallingStalactite(Entity $$0) {
        return this.source(DamageTypes.FALLING_STALACTITE, $$0);
    }

    public DamageSource sting(LivingEntity $$0) {
        return this.source(DamageTypes.STING, $$0);
    }

    public DamageSource mobAttack(LivingEntity $$0) {
        return this.source(DamageTypes.MOB_ATTACK, $$0);
    }

    public DamageSource noAggroMobAttack(LivingEntity $$0) {
        return this.source(DamageTypes.MOB_ATTACK_NO_AGGRO, $$0);
    }

    public DamageSource playerAttack(Player $$0) {
        return this.source(DamageTypes.PLAYER_ATTACK, $$0);
    }

    public DamageSource arrow(AbstractArrow $$0, @Nullable Entity $$1) {
        return this.source(DamageTypes.ARROW, $$0, $$1);
    }

    public DamageSource trident(Entity $$0, @Nullable Entity $$1) {
        return this.source(DamageTypes.TRIDENT, $$0, $$1);
    }

    public DamageSource mobProjectile(Entity $$0, @Nullable LivingEntity $$1) {
        return this.source(DamageTypes.MOB_PROJECTILE, $$0, $$1);
    }

    public DamageSource spit(Entity $$0, @Nullable LivingEntity $$1) {
        return this.source(DamageTypes.SPIT, $$0, $$1);
    }

    public DamageSource windCharge(Entity $$0, @Nullable LivingEntity $$1) {
        return this.source(DamageTypes.WIND_CHARGE, $$0, $$1);
    }

    public DamageSource fireworks(FireworkRocketEntity $$0, @Nullable Entity $$1) {
        return this.source(DamageTypes.FIREWORKS, $$0, $$1);
    }

    public DamageSource fireball(Fireball $$0, @Nullable Entity $$1) {
        if ($$1 == null) {
            return this.source(DamageTypes.UNATTRIBUTED_FIREBALL, $$0);
        }
        return this.source(DamageTypes.FIREBALL, $$0, $$1);
    }

    public DamageSource witherSkull(WitherSkull $$0, Entity $$1) {
        return this.source(DamageTypes.WITHER_SKULL, $$0, $$1);
    }

    public DamageSource thrown(Entity $$0, @Nullable Entity $$1) {
        return this.source(DamageTypes.THROWN, $$0, $$1);
    }

    public DamageSource indirectMagic(Entity $$0, @Nullable Entity $$1) {
        return this.source(DamageTypes.INDIRECT_MAGIC, $$0, $$1);
    }

    public DamageSource thorns(Entity $$0) {
        return this.source(DamageTypes.THORNS, $$0);
    }

    public DamageSource explosion(@Nullable Explosion $$0) {
        return $$0 != null ? this.explosion($$0.getDirectSourceEntity(), $$0.getIndirectSourceEntity()) : this.explosion(null, null);
    }

    public DamageSource explosion(@Nullable Entity $$0, @Nullable Entity $$1) {
        return this.source($$1 != null && $$0 != null ? DamageTypes.PLAYER_EXPLOSION : DamageTypes.EXPLOSION, $$0, $$1);
    }

    public DamageSource sonicBoom(Entity $$0) {
        return this.source(DamageTypes.SONIC_BOOM, $$0);
    }

    public DamageSource badRespawnPointExplosion(Vec3 $$0) {
        return new DamageSource(this.damageTypes.getHolderOrThrow(DamageTypes.BAD_RESPAWN_POINT), $$0);
    }

    public DamageSource outOfBorder() {
        return this.outsideBorder;
    }

    public DamageSource genericKill() {
        return this.genericKill;
    }
}

