/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.slf4j.Logger;

public class AttributeMap {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Holder<Attribute>, AttributeInstance> attributes = new Object2ObjectOpenHashMap();
    private final Set<AttributeInstance> attributesToSync = new ObjectOpenHashSet();
    private final Set<AttributeInstance> attributesToUpdate = new ObjectOpenHashSet();
    private final AttributeSupplier supplier;

    public AttributeMap(AttributeSupplier $$0) {
        this.supplier = $$0;
    }

    private void onAttributeModified(AttributeInstance $$0) {
        this.attributesToUpdate.add($$0);
        if ($$0.getAttribute().value().isClientSyncable()) {
            this.attributesToSync.add($$0);
        }
    }

    public Set<AttributeInstance> getAttributesToSync() {
        return this.attributesToSync;
    }

    public Set<AttributeInstance> getAttributesToUpdate() {
        return this.attributesToUpdate;
    }

    public Collection<AttributeInstance> getSyncableAttributes() {
        return this.attributes.values().stream().filter($$0 -> $$0.getAttribute().value().isClientSyncable()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeInstance getInstance(Holder<Attribute> $$02) {
        return this.attributes.computeIfAbsent($$02, $$0 -> this.supplier.createInstance(this::onAttributeModified, (Holder<Attribute>)$$0));
    }

    public boolean hasAttribute(Holder<Attribute> $$0) {
        return this.attributes.get($$0) != null || this.supplier.hasAttribute($$0);
    }

    public boolean hasModifier(Holder<Attribute> $$0, ResourceLocation $$1) {
        AttributeInstance $$2 = this.attributes.get($$0);
        return $$2 != null ? $$2.getModifier($$1) != null : this.supplier.hasModifier($$0, $$1);
    }

    public double getValue(Holder<Attribute> $$0) {
        AttributeInstance $$1 = this.attributes.get($$0);
        return $$1 != null ? $$1.getValue() : this.supplier.getValue($$0);
    }

    public double getBaseValue(Holder<Attribute> $$0) {
        AttributeInstance $$1 = this.attributes.get($$0);
        return $$1 != null ? $$1.getBaseValue() : this.supplier.getBaseValue($$0);
    }

    public double getModifierValue(Holder<Attribute> $$0, ResourceLocation $$1) {
        AttributeInstance $$2 = this.attributes.get($$0);
        return $$2 != null ? $$2.getModifier($$1).amount() : this.supplier.getModifierValue($$0, $$1);
    }

    public void addTransientAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> $$02) {
        $$02.forEach(($$0, $$1) -> {
            AttributeInstance $$2 = this.getInstance((Holder<Attribute>)$$0);
            if ($$2 != null) {
                $$2.removeModifier($$1.id());
                $$2.addTransientModifier((AttributeModifier)$$1);
            }
        });
    }

    public void removeAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> $$02) {
        $$02.asMap().forEach(($$0, $$12) -> {
            AttributeInstance $$2 = this.attributes.get($$0);
            if ($$2 != null) {
                $$12.forEach($$1 -> $$2.removeModifier($$1.id()));
            }
        });
    }

    public void assignAllValues(AttributeMap $$02) {
        $$02.attributes.values().forEach($$0 -> {
            AttributeInstance $$1 = this.getInstance($$0.getAttribute());
            if ($$1 != null) {
                $$1.replaceFrom((AttributeInstance)$$0);
            }
        });
    }

    public void assignBaseValues(AttributeMap $$02) {
        $$02.attributes.values().forEach($$0 -> {
            AttributeInstance $$1 = this.getInstance($$0.getAttribute());
            if ($$1 != null) {
                $$1.setBaseValue($$0.getBaseValue());
            }
        });
    }

    public ListTag save() {
        ListTag $$0 = new ListTag();
        for (AttributeInstance $$1 : this.attributes.values()) {
            $$0.add($$1.save());
        }
        return $$0;
    }

    public void load(ListTag $$0) {
        for (int $$12 = 0; $$12 < $$0.size(); ++$$12) {
            CompoundTag $$2 = $$0.getCompound($$12);
            String $$3 = $$2.getString("id");
            ResourceLocation $$4 = ResourceLocation.tryParse($$3);
            if ($$4 != null) {
                Util.ifElse(BuiltInRegistries.ATTRIBUTE.getHolder($$4), $$1 -> {
                    AttributeInstance $$2 = this.getInstance((Holder<Attribute>)$$1);
                    if ($$2 != null) {
                        $$2.load($$2);
                    }
                }, () -> LOGGER.warn("Ignoring unknown attribute '{}'", (Object)$$4));
                continue;
            }
            LOGGER.warn("Ignoring malformed attribute '{}'", (Object)$$3);
        }
    }
}

