/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraftforge.fluids.FluidType;

public class Swim
extends Behavior<Mob> {
    private final float chance;

    public Swim(float p_24383_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.chance = p_24383_;
    }

    public static boolean shouldSwim(Mob p_327994_) {
        return p_327994_.isInWater() && p_327994_.getFluidHeight(FluidTags.WATER) > p_327994_.getFluidJumpThreshold() || p_327994_.isInLava() || p_327994_.isInFluidType((fluidType, height) -> p_327994_.canSwimInFluidType((FluidType)fluidType) && height > p_327994_.getFluidJumpThreshold());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_24388_, Mob p_24389_) {
        return Swim.shouldSwim(p_24389_);
    }

    @Override
    protected boolean canStillUse(ServerLevel p_24391_, Mob p_24392_, long p_24393_) {
        return this.checkExtraStartConditions(p_24391_, p_24392_);
    }

    @Override
    protected void tick(ServerLevel p_24399_, Mob p_24400_, long p_24401_) {
        if (p_24400_.getRandom().nextFloat() < this.chance) {
            p_24400_.getJumpControl().jump();
        }
    }
}

