/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties $$0) {
        super($$0);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState $$0, Level $$1, BlockPos $$2, Player $$3) {
        return !$$3.isCreative();
    }

    @Override
    public UseAnim getUseAnimation(ItemStack $$0) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack $$0, LivingEntity $$1) {
        return 72000;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseUsing(ItemStack $$0, Level $$1, LivingEntity $$2, int $$3) {
        void $$5;
        if (!($$2 instanceof Player)) {
            return;
        }
        Player $$4 = (Player)$$2;
        int $$6 = this.getUseDuration($$0, $$2) - $$3;
        if ($$6 < 10) {
            return;
        }
        float $$7 = EnchantmentHelper.getTridentSpinAttackStrength($$0, (LivingEntity)$$5);
        if ($$7 > 0.0f && !$$5.isInWaterOrRain()) {
            return;
        }
        if (TridentItem.isTooDamagedToUse($$0)) {
            return;
        }
        Holder<SoundEvent> $$8 = EnchantmentHelper.pickHighestLevel($$0, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
        if (!$$1.isClientSide) {
            $$0.hurtAndBreak(1, (LivingEntity)$$5, LivingEntity.getSlotForHand($$2.getUsedItemHand()));
            if ($$7 == 0.0f) {
                ThrownTrident $$9 = new ThrownTrident($$1, (LivingEntity)$$5, $$0);
                $$9.shootFromRotation((Entity)$$5, $$5.getXRot(), $$5.getYRot(), 0.0f, 2.5f, 1.0f);
                if ($$5.hasInfiniteMaterials()) {
                    $$9.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                $$1.addFreshEntity($$9);
                $$1.playSound(null, $$9, $$8.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!$$5.hasInfiniteMaterials()) {
                    $$5.getInventory().removeItem($$0);
                }
            }
        }
        $$5.awardStat(Stats.ITEM_USED.get(this));
        if ($$7 > 0.0f) {
            float $$10 = $$5.getYRot();
            float $$11 = $$5.getXRot();
            float $$12 = -Mth.sin($$10 * ((float)Math.PI / 180)) * Mth.cos($$11 * ((float)Math.PI / 180));
            float $$13 = -Mth.sin($$11 * ((float)Math.PI / 180));
            float $$14 = Mth.cos($$10 * ((float)Math.PI / 180)) * Mth.cos($$11 * ((float)Math.PI / 180));
            float $$15 = Mth.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14);
            $$5.push($$12 *= $$7 / $$15, $$13 *= $$7 / $$15, $$14 *= $$7 / $$15);
            $$5.startAutoSpinAttack(20, 8.0f, $$0);
            if ($$5.onGround()) {
                float $$16 = 1.1999999f;
                $$5.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            $$1.playSound(null, (Entity)$$5, $$8.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        ItemStack $$3 = $$1.getItemInHand($$2);
        if (TridentItem.isTooDamagedToUse($$3)) {
            return InteractionResultHolder.fail($$3);
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength($$3, $$1) > 0.0f && !$$1.isInWaterOrRain()) {
            return InteractionResultHolder.fail($$3);
        }
        $$1.startUsingItem($$2);
        return InteractionResultHolder.consume($$3);
    }

    private static boolean isTooDamagedToUse(ItemStack $$0) {
        return $$0.getDamageValue() >= $$0.getMaxDamage() - 1;
    }

    @Override
    public boolean hurtEnemy(ItemStack $$0, LivingEntity $$1, LivingEntity $$2) {
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack $$0, LivingEntity $$1, LivingEntity $$2) {
        $$0.hurtAndBreak(1, $$2, EquipmentSlot.MAINHAND);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public Projectile asProjectile(Level $$0, Position $$1, ItemStack $$2, Direction $$3) {
        ThrownTrident $$4 = new ThrownTrident($$0, $$1.x(), $$1.y(), $$1.z(), $$2.copyWithCount(1));
        $$4.pickup = AbstractArrow.Pickup.ALLOWED;
        return $$4;
    }
}

