/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.TooltipProvider;

public class ArmorTrim
implements TooltipProvider {
    public static final Codec<ArmorTrim> CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)TrimMaterial.CODEC.fieldOf("material").forGetter(ArmorTrim::material), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(ArmorTrim::pattern), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter($$0 -> $$0.showInTooltip)).apply((Applicative)$$02, ArmorTrim::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArmorTrim> STREAM_CODEC = StreamCodec.composite(TrimMaterial.STREAM_CODEC, ArmorTrim::material, TrimPattern.STREAM_CODEC, ArmorTrim::pattern, ByteBufCodecs.BOOL, $$0 -> $$0.showInTooltip, ArmorTrim::new);
    private static final Component UPGRADE_TITLE = Component.translatable(Util.makeDescriptionId("item", ResourceLocation.withDefaultNamespace("smithing_template.upgrade"))).withStyle(ChatFormatting.GRAY);
    private final Holder<TrimMaterial> material;
    private final Holder<TrimPattern> pattern;
    private final boolean showInTooltip;
    private final Function<Holder<ArmorMaterial>, ResourceLocation> innerTexture;
    private final Function<Holder<ArmorMaterial>, ResourceLocation> outerTexture;

    private ArmorTrim(Holder<TrimMaterial> $$0, Holder<TrimPattern> $$1, boolean $$2, Function<Holder<ArmorMaterial>, ResourceLocation> $$3, Function<Holder<ArmorMaterial>, ResourceLocation> $$4) {
        this.material = $$0;
        this.pattern = $$1;
        this.showInTooltip = $$2;
        this.innerTexture = $$3;
        this.outerTexture = $$4;
    }

    public ArmorTrim(Holder<TrimMaterial> $$0, Holder<TrimPattern> $$1, boolean $$22) {
        this.material = $$0;
        this.pattern = $$1;
        this.innerTexture = Util.memoize($$2 -> {
            ResourceLocation $$3 = ((TrimPattern)$$1.value()).assetId();
            String $$4 = ArmorTrim.getColorPaletteSuffix($$0, $$2);
            return $$3.withPath($$1 -> "trims/models/armor/" + $$1 + "_leggings_" + $$4);
        });
        this.outerTexture = Util.memoize($$2 -> {
            ResourceLocation $$3 = ((TrimPattern)$$1.value()).assetId();
            String $$4 = ArmorTrim.getColorPaletteSuffix($$0, $$2);
            return $$3.withPath($$1 -> "trims/models/armor/" + $$1 + "_" + $$4);
        });
        this.showInTooltip = $$22;
    }

    public ArmorTrim(Holder<TrimMaterial> $$0, Holder<TrimPattern> $$1) {
        this($$0, $$1, true);
    }

    private static String getColorPaletteSuffix(Holder<TrimMaterial> $$0, Holder<ArmorMaterial> $$1) {
        Map<Holder<ArmorMaterial>, String> $$2 = $$0.value().overrideArmorMaterials();
        String $$3 = $$2.get($$1);
        if ($$3 != null) {
            return $$3;
        }
        return $$0.value().assetName();
    }

    public boolean hasPatternAndMaterial(Holder<TrimPattern> $$0, Holder<TrimMaterial> $$1) {
        return $$0.equals(this.pattern) && $$1.equals(this.material);
    }

    public Holder<TrimPattern> pattern() {
        return this.pattern;
    }

    public Holder<TrimMaterial> material() {
        return this.material;
    }

    public ResourceLocation innerTexture(Holder<ArmorMaterial> $$0) {
        return this.innerTexture.apply($$0);
    }

    public ResourceLocation outerTexture(Holder<ArmorMaterial> $$0) {
        return this.outerTexture.apply($$0);
    }

    public boolean equals(Object $$0) {
        if ($$0 instanceof ArmorTrim) {
            ArmorTrim $$1 = (ArmorTrim)$$0;
            return this.showInTooltip == $$1.showInTooltip && this.pattern.equals($$1.pattern) && this.material.equals($$1.material);
        }
        return false;
    }

    public int hashCode() {
        int $$0 = this.material.hashCode();
        $$0 = 31 * $$0 + this.pattern.hashCode();
        $$0 = 31 * $$0 + (this.showInTooltip ? 1 : 0);
        return $$0;
    }

    @Override
    public void addToTooltip(Item.TooltipContext $$0, Consumer<Component> $$1, TooltipFlag $$2) {
        if (!this.showInTooltip) {
            return;
        }
        $$1.accept(UPGRADE_TITLE);
        $$1.accept(CommonComponents.space().append(this.pattern.value().copyWithStyle(this.material)));
        $$1.accept(CommonComponents.space().append(this.material.value().description()));
    }

    public ArmorTrim withTooltip(boolean $$0) {
        return new ArmorTrim(this.material, this.pattern, $$0, this.innerTexture, this.outerTexture);
    }
}

