/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;

public class Ingredient
implements Predicate<ItemStack> {
    private static final AtomicInteger INVALIDATION_COUNTER = new AtomicInteger();
    public static final Ingredient EMPTY = new Ingredient(Stream.empty());
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ForgeHooks.ingredientStreamCodec();
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    public static final Codec<Ingredient> VANILLA_CODEC = Ingredient.codec(true);
    public static final MapCodec<Ingredient> VANILLA_MAP_CODEC = MapCodec.assumeMapUnsafe(VANILLA_CODEC);
    public static final Codec<Ingredient> CODEC = ForgeHooks.enhanceIngredientCodec(VANILLA_CODEC);
    private static final Codec<Ingredient> VANILLA_CODEC_NONEMPTY = Ingredient.codec(false);
    public static final Codec<Ingredient> CODEC_NONEMPTY = ForgeHooks.enhanceIngredientCodec(VANILLA_CODEC_NONEMPTY);
    private int invalidationCounter;
    private final boolean isVanilla = this.getClass() == Ingredient.class;

    public static void invalidateAll() {
        INVALIDATION_COUNTER.incrementAndGet();
    }

    protected Ingredient(Stream<? extends Value> p_43907_) {
        this.values = (Value[])p_43907_.toArray(Value[]::new);
    }

    private Ingredient(Value[] p_301101_) {
        this.values = p_301101_;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null || this.checkInvalidation()) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(p_43916_ -> p_43916_.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        if (this.isEmpty()) {
            return p_43914_.isEmpty();
        }
        for (ItemStack itemstack : this.getItems()) {
            if (!itemstack.is(p_43914_.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null || this.checkInvalidation()) {
            this.markValid();
            ItemStack[] aitemstack = this.getItems();
            this.stackingIds = new IntArrayList(aitemstack.length);
            for (ItemStack itemstack : aitemstack) {
                this.stackingIds.add(StackedContents.getStackingIndex(itemstack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object p_300457_) {
        boolean bl;
        if (p_300457_ instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)p_300457_;
            bl = Arrays.equals(this.values, ingredient.values);
        } else {
            bl = false;
        }
        return bl;
    }

    public static Ingredient fromValues(Stream<? extends Value> p_43939_) {
        Ingredient ingredient = new Ingredient(p_43939_);
        return ingredient.isEmpty() ? EMPTY : ingredient;
    }

    public static Ingredient of() {
        return EMPTY;
    }

    public static Ingredient of(ItemLike ... p_43930_) {
        return Ingredient.of(Arrays.stream(p_43930_).map(ItemStack::new));
    }

    public static Ingredient of(ItemStack ... p_43928_) {
        return Ingredient.of(Arrays.stream(p_43928_));
    }

    public static Ingredient of(Stream<ItemStack> p_43922_) {
        return Ingredient.fromValues(p_43922_.filter(p_43944_ -> !p_43944_.isEmpty()).map(ItemValue::new));
    }

    public static Ingredient of(TagKey<Item> p_204133_) {
        return Ingredient.fromValues(Stream.of(new TagValue(p_204133_)));
    }

    public final boolean checkInvalidation() {
        int currentInvalidationCounter = INVALIDATION_COUNTER.get();
        if (this.invalidationCounter != currentInvalidationCounter) {
            this.invalidate();
            return true;
        }
        return false;
    }

    protected final void markValid() {
        this.invalidationCounter = INVALIDATION_COUNTER.get();
    }

    protected void invalidate() {
        this.itemStacks = null;
        this.stackingIds = null;
    }

    public boolean isSimple() {
        return true;
    }

    public final boolean isVanilla() {
        return this.isVanilla;
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        if (!this.isVanilla()) {
            throw new IllegalStateException("Modders must implement Ingredient.codec in their custom Ingredients: " + String.valueOf(this.getClass()));
        }
        return IIngredientSerializer.VANILLA;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Ingredient[");
        for (int x = 0; x < this.values.length; ++x) {
            Value value;
            if (x != 0) {
                buf.append(", ");
            }
            if ((value = this.values[x]) instanceof TagValue) {
                TagValue tag = (TagValue)value;
                buf.append('#').append(tag.tag().location());
                continue;
            }
            value = this.values[x];
            if (value instanceof ItemValue) {
                ItemValue item = (ItemValue)value;
                buf.append(item.item());
                continue;
            }
            buf.append(this.values[x]);
        }
        buf.append(']');
        return buf.toString();
    }

    private static Codec<Ingredient> codec(boolean p_298496_) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(p_296902_ -> !p_298496_ && p_296902_.size() < 1 ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)p_296902_.toArray(new Value[0])), List::of);
        return Codec.either((Codec)codec, Value.CODEC).flatComapMap(p_296900_ -> (Ingredient)p_296900_.map(Ingredient::new, p_296903_ -> new Ingredient(new Value[]{p_296903_})), p_296899_ -> {
            if (p_296899_.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)p_296899_.values[0]));
            }
            return p_296899_.values.length == 0 && !p_298496_ ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)p_296899_.values));
        });
    }

    public static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(ItemValue.CODEC, TagValue.CODEC).xmap(p_300070_ -> (Value)p_300070_.map(p_301348_ -> p_301348_, p_298354_ -> p_298354_), p_299608_ -> {
            if (p_299608_ instanceof TagValue) {
                TagValue ingredient$tagvalue = (TagValue)p_299608_;
                return Either.right((Object)ingredient$tagvalue);
            }
            if (p_299608_ instanceof ItemValue) {
                ItemValue ingredient$itemvalue = (ItemValue)p_299608_;
                return Either.left((Object)ingredient$itemvalue);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();
    }

    public record TagValue(TagKey<Item> tag) implements Value
    {
        static final Codec<TagValue> CODEC = RecordCodecBuilder.create(p_300241_ -> p_300241_.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(p_301340_ -> p_301340_.tag)).apply((Applicative)p_300241_, TagValue::new));

        @Override
        public boolean equals(Object p_298268_) {
            boolean bl;
            if (p_298268_ instanceof TagValue) {
                TagValue ingredient$tagvalue = (TagValue)p_298268_;
                bl = ingredient$tagvalue.tag.location().equals(this.tag.location());
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            if (list.size() == 0) {
                ItemStack marker = new ItemStack(Blocks.BARRIER);
                marker.set(DataComponents.CUSTOM_NAME, Component.literal("Empty Tag: " + String.valueOf(this.tag.location())));
                list.add(marker);
            }
            return list;
        }
    }

    public record ItemValue(ItemStack item) implements Value
    {
        static final Codec<ItemValue> CODEC = RecordCodecBuilder.create(p_327194_ -> p_327194_.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(p_299657_ -> p_299657_.item)).apply((Applicative)p_327194_, ItemValue::new));

        @Override
        public boolean equals(Object p_300135_) {
            boolean bl;
            if (!(p_300135_ instanceof ItemValue)) {
                bl = false;
            } else {
                ItemValue ingredient$itemvalue = (ItemValue)p_300135_;
                bl = ingredient$itemvalue.item.getItem().equals(this.item.getItem()) && ingredient$itemvalue.item.getCount() == this.item.getCount();
            }
            return bl;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

