/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class JigsawBlockEntity
extends BlockEntity {
    public static final String TARGET = "target";
    public static final String POOL = "pool";
    public static final String JOINT = "joint";
    public static final String PLACEMENT_PRIORITY = "placement_priority";
    public static final String SELECTION_PRIORITY = "selection_priority";
    public static final String NAME = "name";
    public static final String FINAL_STATE = "final_state";
    private ResourceLocation name = ResourceLocation.withDefaultNamespace("empty");
    private ResourceLocation target = ResourceLocation.withDefaultNamespace("empty");
    private ResourceKey<StructureTemplatePool> pool = ResourceKey.create(Registries.TEMPLATE_POOL, ResourceLocation.withDefaultNamespace("empty"));
    private JointType joint = JointType.ROLLABLE;
    private String finalState = "minecraft:air";
    private int placementPriority;
    private int selectionPriority;

    public JigsawBlockEntity(BlockPos $$0, BlockState $$1) {
        super(BlockEntityType.JIGSAW, $$0, $$1);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceLocation getTarget() {
        return this.target;
    }

    public ResourceKey<StructureTemplatePool> getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public JointType getJoint() {
        return this.joint;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public void setName(ResourceLocation $$0) {
        this.name = $$0;
    }

    public void setTarget(ResourceLocation $$0) {
        this.target = $$0;
    }

    public void setPool(ResourceKey<StructureTemplatePool> $$0) {
        this.pool = $$0;
    }

    public void setFinalState(String $$0) {
        this.finalState = $$0;
    }

    public void setJoint(JointType $$0) {
        this.joint = $$0;
    }

    public void setPlacementPriority(int $$0) {
        this.placementPriority = $$0;
    }

    public void setSelectionPriority(int $$0) {
        this.selectionPriority = $$0;
    }

    @Override
    protected void saveAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
        super.saveAdditional($$0, $$1);
        $$0.putString(NAME, this.name.toString());
        $$0.putString(TARGET, this.target.toString());
        $$0.putString(POOL, this.pool.location().toString());
        $$0.putString(FINAL_STATE, this.finalState);
        $$0.putString(JOINT, this.joint.getSerializedName());
        $$0.putInt(PLACEMENT_PRIORITY, this.placementPriority);
        $$0.putInt(SELECTION_PRIORITY, this.selectionPriority);
    }

    @Override
    protected void loadAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
        super.loadAdditional($$0, $$1);
        this.name = ResourceLocation.parse($$0.getString(NAME));
        this.target = ResourceLocation.parse($$0.getString(TARGET));
        this.pool = ResourceKey.create(Registries.TEMPLATE_POOL, ResourceLocation.parse($$0.getString(POOL)));
        this.finalState = $$0.getString(FINAL_STATE);
        this.joint = JointType.byName($$0.getString(JOINT)).orElseGet(() -> JigsawBlock.getFrontFacing(this.getBlockState()).getAxis().isHorizontal() ? JointType.ALIGNED : JointType.ROLLABLE);
        this.placementPriority = $$0.getInt(PLACEMENT_PRIORITY);
        this.selectionPriority = $$0.getInt(SELECTION_PRIORITY);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider $$0) {
        return this.saveCustomOnly($$0);
    }

    public void generate(ServerLevel $$0, int $$1, boolean $$2) {
        BlockPos $$3 = this.getBlockPos().relative(this.getBlockState().getValue(JigsawBlock.ORIENTATION).front());
        Registry<StructureTemplatePool> $$4 = $$0.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> $$5 = $$4.getHolderOrThrow(this.pool);
        JigsawPlacement.generateJigsaw($$0, $$5, this.target, $$1, $$3, $$2);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static enum JointType implements StringRepresentable
    {
        ROLLABLE("rollable"),
        ALIGNED("aligned");

        private final String name;

        private JointType(String $$0) {
            this.name = $$0;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static Optional<JointType> byName(String $$0) {
            return Arrays.stream(JointType.values()).filter($$1 -> $$1.getSerializedName().equals($$0)).findFirst();
        }

        public Component getTranslatedName() {
            return Component.translatable("jigsaw_block.joint." + this.name);
        }
    }
}

