/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyComponentsFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyComponentsFunction> CODEC = RecordCodecBuilder.mapCodec($$02 -> CopyComponentsFunction.commonFields($$02).and($$02.group((App)Source.CODEC.fieldOf("source").forGetter($$0 -> $$0.source), (App)DataComponentType.CODEC.listOf().optionalFieldOf("include").forGetter($$0 -> $$0.include), (App)DataComponentType.CODEC.listOf().optionalFieldOf("exclude").forGetter($$0 -> $$0.exclude))).apply((Applicative)$$02, CopyComponentsFunction::new));
    private final Source source;
    private final Optional<List<DataComponentType<?>>> include;
    private final Optional<List<DataComponentType<?>>> exclude;
    private final Predicate<DataComponentType<?>> bakedPredicate;

    CopyComponentsFunction(List<LootItemCondition> $$0, Source $$13, Optional<List<DataComponentType<?>>> $$2, Optional<List<DataComponentType<?>>> $$3) {
        super($$0);
        this.source = $$13;
        this.include = $$2.map(List::copyOf);
        this.exclude = $$3.map(List::copyOf);
        ArrayList $$4 = new ArrayList(2);
        $$3.ifPresent($$12 -> $$4.add($$1 -> !$$12.contains($$1)));
        $$2.ifPresent($$1 -> $$4.add($$1::contains));
        this.bakedPredicate = Util.allOf($$4);
    }

    public LootItemFunctionType<CopyComponentsFunction> getType() {
        return LootItemFunctions.COPY_COMPONENTS;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack $$0, LootContext $$1) {
        DataComponentMap $$2 = this.source.get($$1);
        $$0.applyComponents($$2.filter(this.bakedPredicate));
        return $$0;
    }

    public static Builder copyComponents(Source $$0) {
        return new Builder($$0);
    }

    public static enum Source implements StringRepresentable
    {
        BLOCK_ENTITY("block_entity");

        public static final Codec<Source> CODEC;
        private final String name;

        private Source(String $$0) {
            this.name = $$0;
        }

        public DataComponentMap get(LootContext $$0) {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            BlockEntity $$1 = $$0.getParamOrNull(LootContextParams.BLOCK_ENTITY);
            return $$1 != null ? $$1.collectComponents() : DataComponentMap.EMPTY;
        }

        public Set<LootContextParam<?>> getReferencedContextParams() {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Set.of(LootContextParams.BLOCK_ENTITY);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(Source::values);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Source source;
        private Optional<ImmutableList.Builder<DataComponentType<?>>> include = Optional.empty();
        private Optional<ImmutableList.Builder<DataComponentType<?>>> exclude = Optional.empty();

        Builder(Source $$0) {
            this.source = $$0;
        }

        public Builder include(DataComponentType<?> $$0) {
            if (this.include.isEmpty()) {
                this.include = Optional.of(ImmutableList.builder());
            }
            this.include.get().add($$0);
            return this;
        }

        public Builder exclude(DataComponentType<?> $$0) {
            if (this.exclude.isEmpty()) {
                this.exclude = Optional.of(ImmutableList.builder());
            }
            this.exclude.get().add($$0);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyComponentsFunction(this.getConditions(), this.source, this.include.map(ImmutableList.Builder::build), this.exclude.map(ImmutableList.Builder::build));
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

