/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ResourceKey<? extends Registry<T>> key;
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Reference2IntMap<T> toId = (Reference2IntMap)Util.make(new Reference2IntOpenHashMap(), $$0 -> $$0.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> byLocation = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle registryLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean frozen;
    @Nullable
    private Map<T, Holder.Reference<T>> unregisteredIntrusiveHolders;
    private final HolderLookup.RegistryLookup<T> lookup = new HolderLookup.RegistryLookup<T>(){

        @Override
        public ResourceKey<? extends Registry<? extends T>> key() {
            return MappedRegistry.this.key;
        }

        @Override
        public Lifecycle registryLifecycle() {
            return MappedRegistry.this.registryLifecycle();
        }

        @Override
        public Optional<Holder.Reference<T>> get(ResourceKey<T> $$0) {
            return MappedRegistry.this.getHolder($$0);
        }

        @Override
        public Stream<Holder.Reference<T>> listElements() {
            return MappedRegistry.this.holders();
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> $$0) {
            return MappedRegistry.this.getTag($$0);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            return MappedRegistry.this.getTags().map(Pair::getSecond);
        }
    };
    private final Object tagAdditionLock = new Object();

    public MappedRegistry(ResourceKey<? extends Registry<T>> $$0, Lifecycle $$1) {
        this($$0, $$1, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> $$02, Lifecycle $$1, boolean $$2) {
        this.key = $$02;
        this.registryLifecycle = $$1;
        if ($$2) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> $$0) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf($$0) + ")");
        }
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> $$02, T $$1, RegistrationInfo $$2) {
        Holder.Reference $$4;
        this.validateWrite($$02);
        Objects.requireNonNull($$02);
        Objects.requireNonNull($$1);
        if (this.byLocation.containsKey($$02.location())) {
            Util.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf($$02) + "' to registry"));
        }
        if (this.byValue.containsKey($$1)) {
            Util.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf($$1) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            Holder.Reference<T> $$3 = this.unregisteredIntrusiveHolders.remove($$1);
            if ($$3 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf($$02) + ":" + String.valueOf($$1)));
            }
            $$3.bindKey($$02);
        } else {
            $$4 = this.byKey.computeIfAbsent($$02, $$0 -> Holder.Reference.createStandAlone(this.holderOwner(), $$0));
        }
        this.byKey.put($$02, $$4);
        this.byLocation.put($$02.location(), $$4);
        this.byValue.put($$1, $$4);
        int $$5 = this.byId.size();
        this.byId.add((Object)$$4);
        this.toId.put($$1, $$5);
        this.registrationInfos.put($$02, $$2);
        this.registryLifecycle = this.registryLifecycle.add($$2.lifecycle());
        return $$4;
    }

    @Override
    @Nullable
    public ResourceLocation getKey(T $$0) {
        Holder.Reference<T> $$1 = this.byValue.get($$0);
        return $$1 != null ? $$1.key().location() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T $$0) {
        return Optional.ofNullable(this.byValue.get($$0)).map(Holder.Reference::key);
    }

    @Override
    public int getId(@Nullable T $$0) {
        return this.toId.getInt($$0);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceKey<T> $$0) {
        return MappedRegistry.getValueFromNullable(this.byKey.get($$0));
    }

    @Override
    @Nullable
    public T byId(int $$0) {
        if ($$0 < 0 || $$0 >= this.byId.size()) {
            return null;
        }
        return ((Holder.Reference)this.byId.get($$0)).value();
    }

    @Override
    public Optional<Holder.Reference<T>> getHolder(int $$0) {
        if ($$0 < 0 || $$0 >= this.byId.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.Reference)this.byId.get($$0));
    }

    @Override
    public Optional<Holder.Reference<T>> getHolder(ResourceLocation $$0) {
        return Optional.ofNullable(this.byLocation.get($$0));
    }

    @Override
    public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> $$0) {
        return Optional.ofNullable(this.byKey.get($$0));
    }

    @Override
    public Optional<Holder.Reference<T>> getAny() {
        return this.byId.isEmpty() ? Optional.empty() : Optional.of((Holder.Reference)this.byId.getFirst());
    }

    @Override
    public Holder<T> wrapAsHolder(T $$0) {
        Holder.Reference<T> $$1 = this.byValue.get($$0);
        return $$1 != null ? $$1 : Holder.direct($$0);
    }

    Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> $$02) {
        return this.byKey.computeIfAbsent($$02, $$0 -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)$$0);
            return Holder.Reference.createStandAlone(this.holderOwner(), $$0);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> $$0) {
        return Optional.ofNullable(this.registrationInfos.get($$0));
    }

    @Override
    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.byId.iterator(), Holder::value);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceLocation $$0) {
        Holder.Reference<T> $$1 = this.byLocation.get($$0);
        return MappedRegistry.getValueFromNullable($$1);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> $$0) {
        return $$0 != null ? (T)$$0.value() : null;
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.Reference<T>> holders() {
        return this.byId.stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map($$0 -> Pair.of((Object)((TagKey)$$0.getKey()), (Object)((HolderSet.Named)$$0.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HolderSet.Named<T> getOrCreateTag(TagKey<T> $$0) {
        HolderSet.Named<T> $$1 = this.tags.get($$0);
        if ($$1 != null) {
            return $$1;
        }
        Object object = this.tagAdditionLock;
        synchronized (object) {
            $$1 = this.tags.get($$0);
            if ($$1 != null) {
                return $$1;
            }
            $$1 = this.createTag($$0);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> $$2 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            $$2.put($$0, $$1);
            this.tags = $$2;
        }
        return $$1;
    }

    private HolderSet.Named<T> createTag(TagKey<T> $$0) {
        return new HolderSet.Named<T>(this.holderOwner(), $$0);
    }

    @Override
    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource $$0) {
        return Util.getRandomSafe(this.byId, $$0);
    }

    @Override
    public boolean containsKey(ResourceLocation $$0) {
        return this.byLocation.containsKey($$0);
    }

    @Override
    public boolean containsKey(ResourceKey<T> $$0) {
        return this.byKey.containsKey($$0);
    }

    @Override
    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        this.byValue.forEach((? super K $$0, ? super V $$1) -> $$1.bindValue($$0));
        List<ResourceLocation> $$02 = this.byKey.entrySet().stream().filter($$0 -> !((Holder.Reference)$$0.getValue()).isBound()).map($$0 -> ((ResourceKey)$$0.getKey()).location()).sorted().toList();
        if (!$$02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf($$02));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            if (!this.unregisteredIntrusiveHolders.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
            }
            this.unregisteredIntrusiveHolders = null;
        }
        return this;
    }

    @Override
    public Holder.Reference<T> createIntrusiveHolder(T $$02) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent($$02, $$0 -> Holder.Reference.createIntrusive(this.asLookup(), $$0));
    }

    @Override
    public Optional<HolderSet.Named<T>> getTag(TagKey<T> $$0) {
        return Optional.ofNullable(this.tags.get($$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTags(Map<TagKey<T>, List<Holder<T>>> $$02) {
        IdentityHashMap<Holder.Reference, List> $$12 = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach($$1 -> $$12.put((Holder.Reference)$$1, new ArrayList()));
        $$02.forEach((? super K $$1, ? super V $$2) -> {
            for (Holder $$3 : $$2) {
                if (!$$3.canSerializeIn(this.asLookup())) {
                    throw new IllegalStateException("Can't create named set " + String.valueOf($$1) + " containing value " + String.valueOf($$3) + " from outside registry " + String.valueOf(this));
                }
                if ($$3 instanceof Holder.Reference) {
                    Holder.Reference $$4 = (Holder.Reference)$$3;
                    ((List)$$12.get($$4)).add($$1);
                    continue;
                }
                throw new IllegalStateException("Found direct holder " + String.valueOf($$3) + " value in tag " + String.valueOf($$1));
            }
        });
        Sets.SetView $$22 = Sets.difference(this.tags.keySet(), $$02.keySet());
        if (!$$22.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", this.key(), (Object)$$22.stream().map($$0 -> $$0.location().toString()).sorted().collect(Collectors.joining(", ")));
        }
        Object object = this.tagAdditionLock;
        synchronized (object) {
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> $$3 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            $$02.forEach((? super K $$1, ? super V $$2) -> $$3.computeIfAbsent((TagKey<T>)$$1, this::createTag).bind($$2));
            $$12.forEach(Holder.Reference::bindTags);
            this.tags = $$3;
        }
    }

    @Override
    public void resetTags() {
        this.tags.values().forEach($$0 -> $$0.bind(List.of()));
        this.byKey.values().forEach($$0 -> $$0.bindTags(Set.of()));
    }

    @Override
    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> $$0) {
                return Optional.of(this.getOrThrow($$0));
            }

            @Override
            public Holder.Reference<T> getOrThrow(ResourceKey<T> $$0) {
                return MappedRegistry.this.getOrCreateHolderOrThrow($$0);
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> $$0) {
                return Optional.of(this.getOrThrow($$0));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> $$0) {
                return MappedRegistry.this.getOrCreateTag($$0);
            }
        };
    }

    @Override
    public HolderOwner<T> holderOwner() {
        return this.lookup;
    }

    @Override
    public HolderLookup.RegistryLookup<T> asLookup() {
        return this.lookup;
    }
}

