/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.PacketReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.BundleRecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.TradeRebalanceRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceEnchantmentTagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @DontObfuscate
    public static void main(String[] $$02) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser $$1 = new OptionParser();
        AbstractOptionSpec $$2 = $$1.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder $$3 = $$1.accepts("server", "Include server generators");
        OptionSpecBuilder $$4 = $$1.accepts("client", "Include client generators");
        OptionSpecBuilder $$5 = $$1.accepts("dev", "Include development tools");
        OptionSpecBuilder $$6 = $$1.accepts("reports", "Include data reports");
        OptionSpecBuilder $$7 = $$1.accepts("validate", "Validate inputs");
        OptionSpecBuilder $$8 = $$1.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec $$9 = $$1.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("input", "Input folder").withRequiredArg();
        OptionSet $$11 = $$1.parse($$02);
        if ($$11.has((OptionSpec)$$2) || !$$11.hasOptions()) {
            $$1.printHelpOn((OutputStream)System.out);
            return;
        }
        Path $$12 = Paths.get((String)$$9.value($$11), new String[0]);
        boolean $$13 = $$11.has((OptionSpec)$$8);
        boolean $$14 = $$13 || $$11.has((OptionSpec)$$4);
        boolean $$15 = $$13 || $$11.has((OptionSpec)$$3);
        boolean $$16 = $$13 || $$11.has((OptionSpec)$$5);
        boolean $$17 = $$13 || $$11.has((OptionSpec)$$6);
        boolean $$18 = $$13 || $$11.has((OptionSpec)$$7);
        DataGenerator $$19 = Main.createStandardGenerator($$12, $$11.valuesOf((OptionSpec)$$10).stream().map($$0 -> Paths.get($$0, new String[0])).collect(Collectors.toList()), $$14, $$15, $$16, $$17, $$18, SharedConstants.getCurrentVersion(), true);
        $$19.run();
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> $$0, CompletableFuture<HolderLookup.Provider> $$1) {
        return $$2 -> (DataProvider)$$0.apply($$2, $$1);
    }

    public static DataGenerator createStandardGenerator(Path $$02, Collection<Path> $$12, boolean $$22, boolean $$3, boolean $$4, boolean $$5, boolean $$6, WorldVersion $$7, boolean $$8) {
        DataGenerator $$9 = new DataGenerator($$02, $$7, $$8);
        DataGenerator.PackGenerator $$10 = $$9.getVanillaPack($$22 || $$3);
        $$10.addProvider($$1 -> new SnbtToNbt($$1, $$12).addFilter(new StructureUpdater()));
        CompletableFuture<HolderLookup.Provider> $$11 = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        DataGenerator.PackGenerator $$122 = $$9.getVanillaPack($$22);
        $$122.addProvider(ModelProvider::new);
        DataGenerator.PackGenerator $$13 = $$9.getVanillaPack($$3);
        $$13.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaAdvancementProvider::create, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaLootTableProvider::create, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaRecipeProvider::new, $$11));
        TagsProvider $$14 = $$13.addProvider(Main.bindRegistries(VanillaBlockTagsProvider::new, $$11));
        TagsProvider $$15 = $$13.addProvider($$2 -> new VanillaItemTagsProvider($$2, $$11, $$14.contentsGetter()));
        TagsProvider $$16 = $$13.addProvider(Main.bindRegistries(BiomeTagsProvider::new, $$11));
        TagsProvider $$17 = $$13.addProvider(Main.bindRegistries(BannerPatternTagsProvider::new, $$11));
        TagsProvider $$18 = $$13.addProvider(Main.bindRegistries(StructureTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(CatVariantTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(DamageTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(EntityTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(FlatLevelGeneratorPresetTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(FluidTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(GameEventTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(InstrumentTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(PaintingVariantTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(PoiTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(WorldPresetTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaEnchantmentTagsProvider::new, $$11));
        DataGenerator.PackGenerator $$19 = $$9.getVanillaPack($$4);
        $$19.addProvider($$1 -> new NbtToSnbt($$1, $$12));
        DataGenerator.PackGenerator $$20 = $$9.getVanillaPack($$5);
        $$20.addProvider(Main.bindRegistries(BiomeParametersDumpReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(ItemListReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(BlockListReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(CommandsReport::new, $$11));
        $$20.addProvider(RegistryDumpReport::new);
        $$20.addProvider(PacketReport::new);
        DataGenerator.PackGenerator $$21 = $$9.getBuiltinDatapack($$3, "bundle");
        $$21.addProvider(Main.bindRegistries(BundleRecipeProvider::new, $$11));
        $$21.addProvider($$0 -> PackMetadataGenerator.forFeaturePack($$0, Component.translatable("dataPack.bundle.description"), FeatureFlagSet.of(FeatureFlags.BUNDLE)));
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> $$222 = TradeRebalanceRegistries.createLookup($$11);
        CompletionStage $$23 = $$222.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        DataGenerator.PackGenerator $$24 = $$9.getBuiltinDatapack($$3, "trade_rebalance");
        $$24.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)$$23));
        $$24.addProvider($$0 -> PackMetadataGenerator.forFeaturePack($$0, Component.translatable("dataPack.trade_rebalance.description"), FeatureFlagSet.of(FeatureFlags.TRADE_REBALANCE)));
        $$24.addProvider(Main.bindRegistries(TradeRebalanceLootTableProvider::create, $$11));
        $$24.addProvider(Main.bindRegistries(TradeRebalanceStructureTagsProvider::new, $$11));
        $$24.addProvider(Main.bindRegistries(TradeRebalanceEnchantmentTagsProvider::new, $$11));
        return $$9;
    }
}

