/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public Boolean decode(ByteBuf $$0) {
            return $$0.readBoolean();
        }

        @Override
        public void encode(ByteBuf $$0, Boolean $$1) {
            $$0.writeBoolean($$1.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Boolean)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public Byte decode(ByteBuf $$0) {
            return $$0.readByte();
        }

        @Override
        public void encode(ByteBuf $$0, Byte $$1) {
            $$0.writeByte((int)$$1.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Byte)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        @Override
        public Short decode(ByteBuf $$0) {
            return $$0.readShort();
        }

        @Override
        public void encode(ByteBuf $$0, Short $$1) {
            $$0.writeShort((int)$$1.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Short)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf $$0) {
            return $$0.readUnsignedShort();
        }

        @Override
        public void encode(ByteBuf $$0, Integer $$1) {
            $$0.writeShort($$1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf $$0) {
            return $$0.readInt();
        }

        @Override
        public void encode(ByteBuf $$0, Integer $$1) {
            $$0.writeInt($$1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf $$0) {
            return VarInt.read($$0);
        }

        @Override
        public void encode(ByteBuf $$0, Integer $$1) {
            VarInt.write($$0, $$1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf $$0) {
            return VarLong.read($$0);
        }

        @Override
        public void encode(ByteBuf $$0, Long $$1) {
            VarLong.write($$0, $$1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        public Float decode(ByteBuf $$0) {
            return Float.valueOf($$0.readFloat());
        }

        @Override
        public void encode(ByteBuf $$0, Float $$1) {
            $$0.writeFloat($$1.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Float)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        public Double decode(ByteBuf $$0) {
            return $$0.readDouble();
        }

        @Override
        public void encode(ByteBuf $$0, Double $$1) {
            $$0.writeDouble($$1.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Double)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        @Override
        public byte[] decode(ByteBuf $$0) {
            return FriendlyByteBuf.readByteArray($$0);
        }

        @Override
        public void encode(ByteBuf $$0, byte[] $$1) {
            FriendlyByteBuf.writeByteArray($$0, $$1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (byte[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Tag> TAG = ByteBufCodecs.tagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, Tag> TRUSTED_TAG = ByteBufCodecs.tagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, CompoundTag> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<CompoundTag>>(){

        @Override
        public Optional<CompoundTag> decode(ByteBuf $$0) {
            return Optional.ofNullable(FriendlyByteBuf.readNbt($$0));
        }

        @Override
        public void encode(ByteBuf $$0, Optional<CompoundTag> $$1) {
            FriendlyByteBuf.writeNbt($$0, $$1.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Optional)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> VECTOR3F = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        public Vector3f decode(ByteBuf $$0) {
            return FriendlyByteBuf.readVector3f($$0);
        }

        @Override
        public void encode(ByteBuf $$0, Vector3f $$1) {
            FriendlyByteBuf.writeVector3f($$0, $$1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vector3f)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionf>(){

        @Override
        public Quaternionf decode(ByteBuf $$0) {
            return FriendlyByteBuf.readQuaternion($$0);
        }

        @Override
        public void encode(ByteBuf $$0, Quaternionf $$1) {
            FriendlyByteBuf.writeQuaternion($$0, $$1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Quaternionf)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int MAX_PROPERTY_NAME_LENGTH = 64;
        private static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
        private static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
        private static final int MAX_PROPERTIES = 16;

        @Override
        public PropertyMap decode(ByteBuf $$02) {
            int $$1 = ByteBufCodecs.readCount($$02, 16);
            PropertyMap $$2 = new PropertyMap();
            for (int $$3 = 0; $$3 < $$1; ++$$3) {
                String $$4 = Utf8String.read($$02, 64);
                String $$5 = Utf8String.read($$02, Short.MAX_VALUE);
                String $$6 = FriendlyByteBuf.readNullable($$02, $$0 -> Utf8String.read($$0, 1024));
                Property $$7 = new Property($$4, $$5, $$6);
                $$2.put((Object)$$7.name(), (Object)$$7);
            }
            return $$2;
        }

        @Override
        public void encode(ByteBuf $$02, PropertyMap $$12) {
            ByteBufCodecs.writeCount($$02, $$12.size(), 16);
            for (Property $$2 : $$12.values()) {
                Utf8String.write($$02, $$2.name(), 64);
                Utf8String.write($$02, $$2.value(), Short.MAX_VALUE);
                FriendlyByteBuf.writeNullable($$02, $$2.signature(), ($$0, $$1) -> Utf8String.write($$0, $$1, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (PropertyMap)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = new StreamCodec<ByteBuf, GameProfile>(){

        @Override
        public GameProfile decode(ByteBuf $$0) {
            UUID $$1 = (UUID)UUIDUtil.STREAM_CODEC.decode($$0);
            String $$2 = Utf8String.read($$0, 16);
            GameProfile $$3 = new GameProfile($$1, $$2);
            $$3.getProperties().putAll((Multimap)GAME_PROFILE_PROPERTIES.decode($$0));
            return $$3;
        }

        @Override
        public void encode(ByteBuf $$0, GameProfile $$1) {
            UUIDUtil.STREAM_CODEC.encode($$0, $$1.getId());
            Utf8String.write($$0, $$1.getName(), 16);
            GAME_PROFILE_PROPERTIES.encode($$0, $$1.getProperties());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (GameProfile)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int $$0) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            public byte[] decode(ByteBuf $$02) {
                return FriendlyByteBuf.readByteArray($$02, $$0);
            }

            @Override
            public void encode(ByteBuf $$02, byte[] $$1) {
                if ($$1.length > $$0) {
                    throw new EncoderException("ByteArray with size " + $$1.length + " is bigger than allowed " + $$0);
                }
                FriendlyByteBuf.writeByteArray($$02, $$1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (byte[])object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int $$0) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            public String decode(ByteBuf $$02) {
                return Utf8String.read($$02, $$0);
            }

            @Override
            public void encode(ByteBuf $$02, String $$1) {
                Utf8String.write($$02, $$1, $$0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (String)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Tag> tagCodec(final Supplier<NbtAccounter> $$0) {
        return new StreamCodec<ByteBuf, Tag>(){

            @Override
            public Tag decode(ByteBuf $$02) {
                Tag $$1 = FriendlyByteBuf.readNbt($$02, (NbtAccounter)$$0.get());
                if ($$1 == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return $$1;
            }

            @Override
            public void encode(ByteBuf $$02, Tag $$1) {
                if ($$1 == EndTag.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                FriendlyByteBuf.writeNbt($$02, $$1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (Tag)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> $$02) {
        return ByteBufCodecs.tagCodec($$02).map($$0 -> {
            if ($$0 instanceof CompoundTag) {
                CompoundTag $$1 = (CompoundTag)$$0;
                return $$1;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf($$0));
        }, $$0 -> $$0);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> $$0) {
        return ByteBufCodecs.fromCodec($$0, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> $$0) {
        return ByteBufCodecs.fromCodec($$0, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> $$0, Supplier<NbtAccounter> $$1) {
        return ByteBufCodecs.tagCodec($$1).map($$12 -> $$0.parse((DynamicOps)NbtOps.INSTANCE, $$12).getOrThrow($$1 -> new DecoderException("Failed to decode: " + $$1 + " " + String.valueOf($$12))), $$12 -> (Tag)$$0.encodeStart((DynamicOps)NbtOps.INSTANCE, $$12).getOrThrow($$1 -> new EncoderException("Failed to encode: " + $$1 + " " + String.valueOf($$12))));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> $$0) {
        return ByteBufCodecs.fromCodecWithRegistries($$0, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> $$0) {
        return ByteBufCodecs.fromCodecWithRegistries($$0, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> $$0, Supplier<NbtAccounter> $$1) {
        final StreamCodec<ByteBuf, Tag> $$2 = ByteBufCodecs.tagCodec($$1);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            public T decode(RegistryFriendlyByteBuf $$02) {
                Tag $$12 = (Tag)$$2.decode($$02);
                RegistryOps<Tag> $$22 = $$02.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                return $$0.parse($$22, (Object)$$12).getOrThrow($$1 -> new DecoderException("Failed to decode: " + $$1 + " " + String.valueOf($$12)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf $$02, T $$12) {
                RegistryOps<Tag> $$22 = $$02.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Tag $$3 = (Tag)$$0.encodeStart($$22, $$12).getOrThrow($$1 -> new EncoderException("Failed to encode: " + $$1 + " " + String.valueOf($$12)));
                $$2.encode($$02, $$3);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> $$0) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B $$02) {
                if ($$02.readBoolean()) {
                    return Optional.of($$0.decode($$02));
                }
                return Optional.empty();
            }

            @Override
            public void encode(B $$02, Optional<V> $$1) {
                if ($$1.isPresent()) {
                    $$02.writeBoolean(true);
                    $$0.encode($$02, $$1.get());
                } else {
                    $$02.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static int readCount(ByteBuf $$0, int $$1) {
        int $$2 = VarInt.read($$0);
        if ($$2 > $$1) {
            throw new DecoderException($$2 + " elements exceeded max size of: " + $$1);
        }
        return $$2;
    }

    public static void writeCount(ByteBuf $$0, int $$1, int $$2) {
        if ($$1 > $$2) {
            throw new EncoderException($$1 + " elements exceeded max size of: " + $$2);
        }
        VarInt.write($$0, $$1);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> $$0, StreamCodec<? super B, V> $$1) {
        return ByteBufCodecs.collection($$0, $$1, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> $$0, final StreamCodec<? super B, V> $$1, final int $$2) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B $$02) {
                int $$12 = ByteBufCodecs.readCount($$02, $$2);
                Collection $$22 = (Collection)$$0.apply(Math.min($$12, 65536));
                for (int $$3 = 0; $$3 < $$12; ++$$3) {
                    $$22.add($$1.decode($$02));
                }
                return $$22;
            }

            @Override
            public void encode(B $$02, C $$12) {
                ByteBufCodecs.writeCount($$02, $$12.size(), $$2);
                for (Object $$22 : $$12) {
                    $$1.encode($$02, $$22);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (C)((Collection)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> $$0) {
        return $$1 -> ByteBufCodecs.collection($$0, $$1);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return $$0 -> ByteBufCodecs.collection(ArrayList::new, $$0);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int $$0) {
        return $$1 -> ByteBufCodecs.collection(ArrayList::new, $$1, $$0);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> $$0, StreamCodec<? super B, K> $$1, StreamCodec<? super B, V> $$2) {
        return ByteBufCodecs.map($$0, $$1, $$2, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> $$0, final StreamCodec<? super B, K> $$1, final StreamCodec<? super B, V> $$2, final int $$3) {
        return new StreamCodec<B, M>(){

            @Override
            public void encode(B $$02, M $$12) {
                ByteBufCodecs.writeCount($$02, $$12.size(), $$3);
                $$12.forEach(($$3, $$4) -> {
                    $$1.encode($$02, $$3);
                    $$2.encode($$02, $$4);
                });
            }

            @Override
            public M decode(B $$02) {
                int $$12 = ByteBufCodecs.readCount($$02, $$3);
                Map $$22 = (Map)$$0.apply(Math.min($$12, 65536));
                for (int $$32 = 0; $$32 < $$12; ++$$32) {
                    Object $$4 = $$1.decode($$02);
                    Object $$5 = $$2.decode($$02);
                    $$22.put($$4, $$5);
                }
                return $$22;
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (M)((Map)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> $$0, final StreamCodec<? super B, R> $$1) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B $$02) {
                if ($$02.readBoolean()) {
                    return Either.left($$0.decode($$02));
                }
                return Either.right($$1.decode($$02));
            }

            @Override
            public void encode(B $$02, Either<L, R> $$12) {
                $$12.ifLeft($$2 -> {
                    $$02.writeBoolean(true);
                    $$0.encode($$02, $$2);
                }).ifRight($$2 -> {
                    $$02.writeBoolean(false);
                    $$1.encode($$02, $$2);
                });
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Either)((Either)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> $$0, final ToIntFunction<T> $$1) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T decode(ByteBuf $$02) {
                int $$12 = VarInt.read($$02);
                return $$0.apply($$12);
            }

            @Override
            public void encode(ByteBuf $$02, T $$12) {
                int $$2 = $$1.applyAsInt($$12);
                VarInt.write($$02, $$2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(IdMap<T> $$0) {
        return ByteBufCodecs.idMapper($$0::byIdOrThrow, $$0::getIdOrThrow);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends Registry<T>> $$0, final Function<Registry<T>, IdMap<R>> $$1) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private IdMap<R> getRegistryOrThrow(RegistryFriendlyByteBuf $$02) {
                return (IdMap)$$1.apply($$02.registryAccess().registryOrThrow($$0));
            }

            @Override
            public R decode(RegistryFriendlyByteBuf $$02) {
                int $$12 = VarInt.read($$02);
                return this.getRegistryOrThrow($$02).byIdOrThrow($$12);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf $$02, R $$12) {
                int $$2 = this.getRegistryOrThrow($$02).getIdOrThrow($$12);
                VarInt.write($$02, $$2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends Registry<T>> $$02) {
        return ByteBufCodecs.registry($$02, $$0 -> $$0);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends Registry<T>> $$0) {
        return ByteBufCodecs.registry($$0, Registry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends Registry<T>> $$0, final StreamCodec<? super RegistryFriendlyByteBuf, T> $$1) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private IdMap<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf $$02) {
                return $$02.registryAccess().registryOrThrow($$0).asHolderIdMap();
            }

            @Override
            public Holder<T> decode(RegistryFriendlyByteBuf $$02) {
                int $$12 = VarInt.read($$02);
                if ($$12 == 0) {
                    return Holder.direct($$1.decode($$02));
                }
                return this.getRegistryOrThrow($$02).byIdOrThrow($$12 - 1);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf $$02, Holder<T> $$12) {
                switch ($$12.kind()) {
                    case REFERENCE: {
                        int $$2 = this.getRegistryOrThrow($$02).getIdOrThrow($$12);
                        VarInt.write($$02, $$2 + 1);
                        break;
                    }
                    case DIRECT: {
                        VarInt.write($$02, 0);
                        $$1.encode($$02, $$12.value());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (Holder)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends Registry<T>> $$0) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry($$0);
            }

            @Override
            public HolderSet<T> decode(RegistryFriendlyByteBuf $$02) {
                int $$1 = VarInt.read($$02) - 1;
                if ($$1 == -1) {
                    Registry $$2 = $$02.registryAccess().registryOrThrow($$0);
                    return $$2.getTag(TagKey.create($$0, (ResourceLocation)ResourceLocation.STREAM_CODEC.decode($$02))).orElseThrow();
                }
                ArrayList<Holder> $$3 = new ArrayList<Holder>(Math.min($$1, 65536));
                for (int $$4 = 0; $$4 < $$1; ++$$4) {
                    $$3.add((Holder)this.holderCodec.decode($$02));
                }
                return HolderSet.direct($$3);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf $$02, HolderSet<T> $$1) {
                Optional $$2 = $$1.unwrapKey();
                if ($$2.isPresent()) {
                    VarInt.write($$02, 0);
                    ResourceLocation.STREAM_CODEC.encode($$02, $$2.get().location());
                } else {
                    VarInt.write($$02, $$1.size() + 1);
                    for (Holder holder : $$1) {
                        this.holderCodec.encode($$02, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (HolderSet)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }
}

