/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.slf4j.Logger;

public class ReloadableServerResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final ReloadableServerRegistries.Holder fullRegistryHolder;
    private final ConfigurableRegistryLookup registryLookup;
    private final Commands commands;
    private final RecipeManager recipes;
    private final TagManager tagManager;
    private final ServerAdvancementManager advancements;
    private final ServerFunctionLibrary functionLibrary;

    private ReloadableServerResources(RegistryAccess.Frozen $$0, FeatureFlagSet $$1, Commands.CommandSelection $$2, int $$3) {
        this.fullRegistryHolder = new ReloadableServerRegistries.Holder($$0);
        this.registryLookup = new ConfigurableRegistryLookup($$0);
        this.registryLookup.missingTagAccessPolicy(MissingTagAccessPolicy.CREATE_NEW);
        this.recipes = new RecipeManager(this.registryLookup);
        this.tagManager = new TagManager($$0);
        this.commands = new Commands($$2, CommandBuildContext.simple(this.registryLookup, $$1));
        this.advancements = new ServerAdvancementManager(this.registryLookup);
        this.functionLibrary = new ServerFunctionLibrary($$3, this.commands.getDispatcher());
    }

    public ServerFunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public ReloadableServerRegistries.Holder fullRegistries() {
        return this.fullRegistryHolder;
    }

    public RecipeManager getRecipeManager() {
        return this.recipes;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public ServerAdvancementManager getAdvancements() {
        return this.advancements;
    }

    public List<PreparableReloadListener> listeners() {
        return List.of(this.tagManager, this.recipes, this.functionLibrary, this.advancements);
    }

    public static CompletableFuture<ReloadableServerResources> loadResources(ResourceManager $$0, LayeredRegistryAccess<RegistryLayer> $$1, FeatureFlagSet $$2, Commands.CommandSelection $$3, int $$4, Executor $$5, Executor $$62) {
        return ReloadableServerRegistries.reload($$1, $$0, $$5).thenCompose($$6 -> {
            ReloadableServerResources $$7 = new ReloadableServerResources($$6.compositeAccess(), $$2, $$3, $$4);
            return ((CompletableFuture)SimpleReloadInstance.create($$0, $$7.listeners(), $$5, $$62, DATA_RELOAD_INITIAL_TASK, LOGGER.isDebugEnabled()).done().whenComplete(($$1, $$2) -> $$0.registryLookup.missingTagAccessPolicy(MissingTagAccessPolicy.FAIL))).thenApply($$1 -> $$7);
        });
    }

    public void updateRegistryTags() {
        this.tagManager.getResult().forEach($$0 -> ReloadableServerResources.updateRegistryTags(this.fullRegistryHolder.get(), $$0));
        AbstractFurnaceBlockEntity.invalidateCache();
        Blocks.rebuildCache();
    }

    private static <T> void updateRegistryTags(RegistryAccess $$02, TagManager.LoadResult<T> $$12) {
        ResourceKey $$2 = $$12.key();
        Map $$3 = $$12.tags().entrySet().stream().collect(Collectors.toUnmodifiableMap($$1 -> TagKey.create($$2, (ResourceLocation)$$1.getKey()), $$0 -> List.copyOf((Collection)$$0.getValue())));
        $$02.registryOrThrow($$2).bindTags($$3);
    }

    static class ConfigurableRegistryLookup
    implements HolderLookup.Provider {
        private final RegistryAccess registryAccess;
        MissingTagAccessPolicy missingTagAccessPolicy = MissingTagAccessPolicy.FAIL;

        ConfigurableRegistryLookup(RegistryAccess $$0) {
            this.registryAccess = $$0;
        }

        public void missingTagAccessPolicy(MissingTagAccessPolicy $$0) {
            this.missingTagAccessPolicy = $$0;
        }

        @Override
        public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
            return this.registryAccess.listRegistries();
        }

        @Override
        public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> $$02) {
            return this.registryAccess.registry($$02).map($$0 -> this.createDispatchedLookup($$0.asLookup(), $$0.asTagAddingLookup()));
        }

        private <T> HolderLookup.RegistryLookup<T> createDispatchedLookup(final HolderLookup.RegistryLookup<T> $$0, final HolderLookup.RegistryLookup<T> $$1) {
            return new HolderLookup.RegistryLookup.Delegate<T>(){

                @Override
                public HolderLookup.RegistryLookup<T> parent() {
                    return switch (missingTagAccessPolicy.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 1 -> $$0;
                        case 0 -> $$1;
                    };
                }
            };
        }
    }

    static enum MissingTagAccessPolicy {
        CREATE_NEW,
        FAIL;

    }
}

