/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider $$0) {
        super(GSON, Registries.elementsDirPath(Registries.ADVANCEMENT));
        this.registries = $$0;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> $$0, ResourceManager $$1, ProfilerFiller $$22) {
        RegistryOps $$32 = this.registries.createSerializationContext(JsonOps.INSTANCE);
        ImmutableMap.Builder $$4 = ImmutableMap.builder();
        $$0.forEach(($$2, $$3) -> {
            try {
                Advancement $$4 = (Advancement)Advancement.CODEC.parse((DynamicOps)$$32, $$3).getOrThrow(JsonParseException::new);
                this.validate((ResourceLocation)$$2, $$4);
                $$4.put($$2, (Object)new AdvancementHolder((ResourceLocation)$$2, $$4));
            }
            catch (Exception $$5) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", $$2, (Object)$$5.getMessage());
            }
        });
        this.advancements = $$4.buildOrThrow();
        AdvancementTree $$5 = new AdvancementTree();
        $$5.addAll(this.advancements.values());
        for (AdvancementNode $$6 : $$5.roots()) {
            if (!$$6.holder().value().display().isPresent()) continue;
            TreeNodePosition.run($$6);
        }
        this.tree = $$5;
    }

    private void validate(ResourceLocation $$0, Advancement $$12) {
        ProblemReporter.Collector $$2 = new ProblemReporter.Collector();
        $$12.validate($$2, this.registries.asGetterLookup());
        $$2.getReport().ifPresent($$1 -> LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)$$0, $$1));
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation $$0) {
        return this.advancements.get($$0);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

