/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

class WeavingMobEffect
extends MobEffect {
    private final ToIntFunction<RandomSource> maxCobwebs;

    protected WeavingMobEffect(MobEffectCategory $$0, int $$1, ToIntFunction<RandomSource> $$2) {
        super($$0, $$1, ParticleTypes.ITEM_COBWEB);
        this.maxCobwebs = $$2;
    }

    @Override
    public void onMobRemoved(LivingEntity $$0, int $$1, Entity.RemovalReason $$2) {
        if ($$2 == Entity.RemovalReason.KILLED && ($$0 instanceof Player || $$0.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
            this.spawnCobwebsRandomlyAround($$0.level(), $$0.getRandom(), $$0.getOnPos());
        }
    }

    private void spawnCobwebsRandomlyAround(Level $$0, RandomSource $$1, BlockPos $$2) {
        HashSet $$3 = Sets.newHashSet();
        int $$4 = this.maxCobwebs.applyAsInt($$1);
        for (BlockPos $$5 : BlockPos.randomInCube($$1, 15, $$2, 1)) {
            BlockPos $$6 = $$5.below();
            if ($$3.contains($$5) || !$$0.getBlockState($$5).canBeReplaced() || !$$0.getBlockState($$6).isFaceSturdy($$0, $$6, Direction.UP)) continue;
            $$3.add($$5.immutable());
            if ($$3.size() < $$4) continue;
            break;
        }
        for (BlockPos $$7 : $$3) {
            $$0.setBlock($$7, Blocks.COBWEB.defaultBlockState(), 3);
            $$0.levelEvent(3018, $$7, 0);
        }
    }
}

