/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public final class VillagerType {
    public static final VillagerType DESERT = VillagerType.register("desert");
    public static final VillagerType JUNGLE = VillagerType.register("jungle");
    public static final VillagerType PLAINS = VillagerType.register("plains");
    public static final VillagerType SAVANNA = VillagerType.register("savanna");
    public static final VillagerType SNOW = VillagerType.register("snow");
    public static final VillagerType SWAMP = VillagerType.register("swamp");
    public static final VillagerType TAIGA = VillagerType.register("taiga");
    private final String name;
    private static final Map<ResourceKey<Biome>, VillagerType> BY_BIOME = Util.make(Maps.newHashMap(), $$0 -> {
        $$0.put(Biomes.BADLANDS, DESERT);
        $$0.put(Biomes.DESERT, DESERT);
        $$0.put(Biomes.ERODED_BADLANDS, DESERT);
        $$0.put(Biomes.WOODED_BADLANDS, DESERT);
        $$0.put(Biomes.BAMBOO_JUNGLE, JUNGLE);
        $$0.put(Biomes.JUNGLE, JUNGLE);
        $$0.put(Biomes.SPARSE_JUNGLE, JUNGLE);
        $$0.put(Biomes.SAVANNA_PLATEAU, SAVANNA);
        $$0.put(Biomes.SAVANNA, SAVANNA);
        $$0.put(Biomes.WINDSWEPT_SAVANNA, SAVANNA);
        $$0.put(Biomes.DEEP_FROZEN_OCEAN, SNOW);
        $$0.put(Biomes.FROZEN_OCEAN, SNOW);
        $$0.put(Biomes.FROZEN_RIVER, SNOW);
        $$0.put(Biomes.ICE_SPIKES, SNOW);
        $$0.put(Biomes.SNOWY_BEACH, SNOW);
        $$0.put(Biomes.SNOWY_TAIGA, SNOW);
        $$0.put(Biomes.SNOWY_PLAINS, SNOW);
        $$0.put(Biomes.GROVE, SNOW);
        $$0.put(Biomes.SNOWY_SLOPES, SNOW);
        $$0.put(Biomes.FROZEN_PEAKS, SNOW);
        $$0.put(Biomes.JAGGED_PEAKS, SNOW);
        $$0.put(Biomes.SWAMP, SWAMP);
        $$0.put(Biomes.MANGROVE_SWAMP, SWAMP);
        $$0.put(Biomes.OLD_GROWTH_SPRUCE_TAIGA, TAIGA);
        $$0.put(Biomes.OLD_GROWTH_PINE_TAIGA, TAIGA);
        $$0.put(Biomes.WINDSWEPT_GRAVELLY_HILLS, TAIGA);
        $$0.put(Biomes.WINDSWEPT_HILLS, TAIGA);
        $$0.put(Biomes.TAIGA, TAIGA);
        $$0.put(Biomes.WINDSWEPT_FOREST, TAIGA);
    });

    private VillagerType(String $$0) {
        this.name = $$0;
    }

    public String toString() {
        return this.name;
    }

    private static VillagerType register(String $$0) {
        return Registry.register(BuiltInRegistries.VILLAGER_TYPE, ResourceLocation.withDefaultNamespace($$0), new VillagerType($$0));
    }

    public static VillagerType byBiome(Holder<Biome> $$0) {
        return $$0.unwrapKey().map(BY_BIOME::get).orElse(PLAINS);
    }
}

