/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class ThrowableProjectile
extends Projectile {
    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> $$0, Level $$1) {
        super((EntityType<? extends Projectile>)$$0, $$1);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> $$0, double $$1, double $$2, double $$3, Level $$4) {
        this($$0, $$4);
        this.setPos($$1, $$2, $$3);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> $$0, LivingEntity $$1, Level $$2) {
        this($$0, $$1.getX(), $$1.getEyeY() - (double)0.1f, $$1.getZ(), $$2);
        this.setOwner($$1);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double $$0) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1)) {
            $$1 = 4.0;
        }
        return $$0 < ($$1 *= 64.0) * $$1;
    }

    @Override
    public boolean canUsePortal(boolean $$0) {
        return true;
    }

    @Override
    public void tick() {
        float $$8;
        super.tick();
        HitResult $$0 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        if ($$0.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf($$0);
        }
        this.checkInsideBlocks();
        Vec3 $$1 = this.getDeltaMovement();
        double $$2 = this.getX() + $$1.x;
        double $$3 = this.getY() + $$1.y;
        double $$4 = this.getZ() + $$1.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int $$5 = 0; $$5 < 4; ++$$5) {
                float $$6 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$2 - $$1.x * 0.25, $$3 - $$1.y * 0.25, $$4 - $$1.z * 0.25, $$1.x, $$1.y, $$1.z);
            }
            float $$7 = 0.8f;
        } else {
            $$8 = 0.99f;
        }
        this.setDeltaMovement($$1.scale($$8));
        this.applyGravity();
        this.setPos($$2, $$3, $$4);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }
}

