/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> $$0, Level $$1) {
        super((EntityType<? extends ThrowableItemProjectile>)$$0, $$1);
    }

    public ThrownEnderpearl(Level $$0, LivingEntity $$1) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.ENDER_PEARL, $$1, $$0);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void onHitEntity(EntityHitResult $$0) {
        super.onHitEntity($$0);
        $$0.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onHit(HitResult $$0) {
        void $$3;
        block12: {
            block11: {
                super.onHit($$0);
                for (int $$1 = 0; $$1 < 32; ++$$1) {
                    this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
                }
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block11;
                ServerLevel $$2 = (ServerLevel)level;
                if (!this.isRemoved()) break block12;
            }
            return;
        }
        Entity $$4 = this.getOwner();
        if ($$4 == null || !ThrownEnderpearl.isAllowedToTeleportOwner($$4, (Level)$$3)) {
            this.discard();
            return;
        }
        if ($$4.isPassenger()) {
            $$4.unRide();
        }
        if ($$4 instanceof ServerPlayer) {
            ServerPlayer $$5 = (ServerPlayer)$$4;
            if ($$5.connection.isAcceptingMessages()) {
                Endermite $$6;
                if (this.random.nextFloat() < 0.05f && $$3.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && ($$6 = EntityType.ENDERMITE.create((Level)$$3)) != null) {
                    $$6.moveTo($$4.getX(), $$4.getY(), $$4.getZ(), $$4.getYRot(), $$4.getXRot());
                    $$3.addFreshEntity($$6);
                }
                $$4.changeDimension(new DimensionTransition((ServerLevel)$$3, this.position(), $$4.getDeltaMovement(), $$4.getYRot(), $$4.getXRot(), DimensionTransition.DO_NOTHING));
                $$4.resetFallDistance();
                $$5.resetCurrentImpulseContext();
                $$4.hurt(this.damageSources().fall(), 5.0f);
                this.playSound((Level)$$3, this.position());
            }
        } else {
            $$4.changeDimension(new DimensionTransition((ServerLevel)$$3, this.position(), $$4.getDeltaMovement(), $$4.getYRot(), $$4.getXRot(), DimensionTransition.DO_NOTHING));
            $$4.resetFallDistance();
            this.playSound((Level)$$3, this.position());
        }
        this.discard();
    }

    private static boolean isAllowedToTeleportOwner(Entity $$0, Level $$1) {
        if ($$0.level().dimension() == $$1.dimension()) {
            if ($$0 instanceof LivingEntity) {
                LivingEntity $$2 = (LivingEntity)$$0;
                return $$2.isAlive() && !$$2.isSleeping();
            }
            return $$0.isAlive();
        }
        return $$0.canUsePortal(true);
    }

    @Override
    public void tick() {
        Entity $$0 = this.getOwner();
        if ($$0 instanceof ServerPlayer && !$$0.isAlive() && this.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else {
            super.tick();
        }
    }

    private void playSound(Level $$0, Vec3 $$1) {
        $$0.playSound(null, $$1.x, $$1.y, $$1.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    public boolean canChangeDimensions(Level $$0, Level $$1) {
        Entity entity;
        if ($$0.dimension() == Level.END && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$2 = (ServerPlayer)entity;
            return super.canChangeDimensions($$0, $$1) && $$2.seenCredits;
        }
        return super.canChangeDimensions($$0, $$1);
    }

    @Override
    protected void onInsideBlock(BlockState $$0) {
        Entity entity;
        super.onInsideBlock($$0);
        if ($$0.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)entity;
            $$1.onInsideBlock($$0);
        }
    }
}

