/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class AdventureModePredicate {
    private static final Codec<AdventureModePredicate> SIMPLE_CODEC = BlockPredicate.CODEC.flatComapMap($$0 -> new AdventureModePredicate(List.of($$0), true), $$0 -> DataResult.error(() -> "Cannot encode"));
    private static final Codec<AdventureModePredicate> FULL_CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)ExtraCodecs.nonEmptyList(BlockPredicate.CODEC.listOf()).fieldOf("predicates").forGetter($$0 -> $$0.predicates), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(AdventureModePredicate::showInTooltip)).apply((Applicative)$$02, AdventureModePredicate::new));
    public static final Codec<AdventureModePredicate> CODEC = Codec.withAlternative(FULL_CODEC, SIMPLE_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> STREAM_CODEC = StreamCodec.composite(BlockPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), $$0 -> $$0.predicates, ByteBufCodecs.BOOL, AdventureModePredicate::showInTooltip, AdventureModePredicate::new);
    public static final Component CAN_BREAK_HEADER = Component.translatable("item.canBreak").withStyle(ChatFormatting.GRAY);
    public static final Component CAN_PLACE_HEADER = Component.translatable("item.canPlace").withStyle(ChatFormatting.GRAY);
    private static final Component UNKNOWN_USE = Component.translatable("item.canUse.unknown").withStyle(ChatFormatting.GRAY);
    private final List<BlockPredicate> predicates;
    private final boolean showInTooltip;
    private final List<Component> tooltip;
    @Nullable
    private BlockInWorld lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    private AdventureModePredicate(List<BlockPredicate> $$0, boolean $$1, List<Component> $$2) {
        this.predicates = $$0;
        this.showInTooltip = $$1;
        this.tooltip = $$2;
    }

    public AdventureModePredicate(List<BlockPredicate> $$0, boolean $$1) {
        this.predicates = $$0;
        this.showInTooltip = $$1;
        this.tooltip = AdventureModePredicate.computeTooltip($$0);
    }

    private static boolean areSameBlocks(BlockInWorld $$0, @Nullable BlockInWorld $$1, boolean $$2) {
        if ($$1 == null || $$0.getState() != $$1.getState()) {
            return false;
        }
        if (!$$2) {
            return true;
        }
        if ($$0.getEntity() == null && $$1.getEntity() == null) {
            return true;
        }
        if ($$0.getEntity() == null || $$1.getEntity() == null) {
            return false;
        }
        RegistryAccess $$3 = $$0.getLevel().registryAccess();
        return Objects.equals($$0.getEntity().saveWithId($$3), $$1.getEntity().saveWithId($$3));
    }

    public boolean test(BlockInWorld $$0) {
        if (AdventureModePredicate.areSameBlocks($$0, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = $$0;
        this.checksBlockEntity = false;
        for (BlockPredicate $$1 : this.predicates) {
            if (!$$1.matches($$0)) continue;
            this.checksBlockEntity |= $$1.requiresNbt();
            this.lastResult = true;
            return true;
        }
        this.lastResult = false;
        return false;
    }

    public void addToTooltip(Consumer<Component> $$0) {
        this.tooltip.forEach($$0);
    }

    public AdventureModePredicate withTooltip(boolean $$0) {
        return new AdventureModePredicate(this.predicates, $$0, this.tooltip);
    }

    private static List<Component> computeTooltip(List<BlockPredicate> $$02) {
        for (BlockPredicate $$1 : $$02) {
            if (!$$1.blocks().isEmpty()) continue;
            return List.of(UNKNOWN_USE);
        }
        return $$02.stream().flatMap($$0 -> $$0.blocks().orElseThrow().stream()).distinct().map($$0 -> ((Block)$$0.value()).getName().withStyle(ChatFormatting.DARK_GRAY)).toList();
    }

    public boolean showInTooltip() {
        return this.showInTooltip;
    }

    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if ($$0 instanceof AdventureModePredicate) {
            AdventureModePredicate $$1 = (AdventureModePredicate)$$0;
            return this.predicates.equals($$1.predicates) && this.showInTooltip == $$1.showInTooltip;
        }
        return false;
    }

    public int hashCode() {
        return this.predicates.hashCode() * 31 + (this.showInTooltip ? 1 : 0);
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.predicates) + ", showInTooltip=" + this.showInTooltip + "}";
    }
}

