/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AnimalArmorItem
extends ArmorItem {
    private final ResourceLocation textureLocation;
    @Nullable
    private final ResourceLocation overlayTextureLocation;
    private final BodyType bodyType;

    public AnimalArmorItem(Holder<ArmorMaterial> $$0, BodyType $$1, boolean $$2, Item.Properties $$3) {
        super($$0, ArmorItem.Type.BODY, $$3);
        this.bodyType = $$1;
        ResourceLocation $$4 = $$1.textureLocator.apply($$0.unwrapKey().orElseThrow().location());
        this.textureLocation = $$4.withSuffix(".png");
        this.overlayTextureLocation = $$2 ? $$4.withSuffix("_overlay.png") : null;
    }

    public ResourceLocation getTexture() {
        return this.textureLocation;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.overlayTextureLocation;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    @Override
    public SoundEvent getBreakingSound() {
        return this.bodyType.breakingSound;
    }

    @Override
    public boolean isEnchantable(ItemStack $$0) {
        return false;
    }

    public static enum BodyType {
        EQUESTRIAN($$02 -> $$02.withPath($$0 -> "textures/entity/horse/armor/horse_armor_" + $$0), SoundEvents.ITEM_BREAK),
        CANINE($$0 -> $$0.withPath("textures/entity/wolf/wolf_armor"), SoundEvents.WOLF_ARMOR_BREAK);

        final Function<ResourceLocation, ResourceLocation> textureLocator;
        final SoundEvent breakingSound;

        private BodyType(Function<ResourceLocation, ResourceLocation> $$0, SoundEvent $$1) {
            this.textureLocator = $$0;
            this.breakingSound = $$1;
        }
    }
}

