/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class MinecartItem
extends Item {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        /*
         * WARNING - void declaration
         */
        @Override
        public ItemStack execute(BlockSource $$0, ItemStack $$1) {
            void $$17;
            RailShape $$10;
            Direction $$2 = $$0.state().getValue(DispenserBlock.FACING);
            ServerLevel $$3 = $$0.level();
            Vec3 $$4 = $$0.center();
            double $$5 = $$4.x() + (double)$$2.getStepX() * 1.125;
            double $$6 = Math.floor($$4.y()) + (double)$$2.getStepY();
            double $$7 = $$4.z() + (double)$$2.getStepZ() * 1.125;
            BlockPos $$8 = $$0.pos().relative($$2);
            BlockState $$9 = $$3.getBlockState($$8);
            RailShape railShape = $$10 = $$9.getBlock() instanceof BaseRailBlock ? $$9.getValue(((BaseRailBlock)$$9.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            if ($$9.is(BlockTags.RAILS)) {
                if ($$10.isAscending()) {
                    double $$11 = 0.6;
                } else {
                    double $$12 = 0.1;
                }
            } else if ($$9.isAir() && $$3.getBlockState($$8.below()).is(BlockTags.RAILS)) {
                RailShape $$14;
                BlockState $$13 = $$3.getBlockState($$8.below());
                RailShape railShape2 = $$14 = $$13.getBlock() instanceof BaseRailBlock ? $$13.getValue(((BaseRailBlock)$$13.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                if ($$2 == Direction.DOWN || !$$14.isAscending()) {
                    double $$15 = -0.9;
                } else {
                    double $$16 = -0.4;
                }
            } else {
                return this.defaultDispenseItemBehavior.dispense($$0, $$1);
            }
            AbstractMinecart $$18 = AbstractMinecart.createMinecart($$3, $$5, $$6 + $$17, $$7, ((MinecartItem)$$1.getItem()).type, $$1, null);
            $$3.addFreshEntity($$18);
            $$1.shrink(1);
            return $$1;
        }

        @Override
        protected void playSound(BlockSource $$0) {
            $$0.level().levelEvent(1000, $$0.pos(), 0);
        }
    };
    final AbstractMinecart.Type type;

    public MinecartItem(AbstractMinecart.Type $$0, Item.Properties $$1) {
        super($$1);
        this.type = $$0;
        DispenserBlock.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        BlockPos $$2;
        Level $$1 = $$0.getLevel();
        BlockState $$3 = $$1.getBlockState($$2 = $$0.getClickedPos());
        if (!$$3.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack $$4 = $$0.getItemInHand();
        if ($$1 instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)$$1;
            RailShape $$6 = $$3.getBlock() instanceof BaseRailBlock ? $$3.getValue(((BaseRailBlock)$$3.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            double $$7 = 0.0;
            if ($$6.isAscending()) {
                $$7 = 0.5;
            }
            AbstractMinecart $$8 = AbstractMinecart.createMinecart($$5, (double)$$2.getX() + 0.5, (double)$$2.getY() + 0.0625 + $$7, (double)$$2.getZ() + 0.5, this.type, $$4, $$0.getPlayer());
            $$5.addFreshEntity($$8);
            $$5.gameEvent(GameEvent.ENTITY_PLACE, $$2, GameEvent.Context.of($$0.getPlayer(), $$5.getBlockState($$2.below())));
        }
        $$4.shrink(1);
        return InteractionResult.sidedSuccess($$1.isClientSide);
    }
}

