/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
    private final int backgroundColor;
    private final int highlightColor;
    private final EntityType<?> defaultType;

    public SpawnEggItem(EntityType<? extends Mob> $$0, int $$1, int $$2, Item.Properties $$3) {
        super($$3);
        this.defaultType = $$0;
        this.backgroundColor = $$1;
        this.highlightColor = $$2;
        BY_ID.put($$0, this);
    }

    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        BlockPos $$9;
        Level $$1 = $$0.getLevel();
        if (!($$1 instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack $$2 = $$0.getItemInHand();
        BlockPos $$3 = $$0.getClickedPos();
        Direction $$4 = $$0.getClickedFace();
        BlockState $$5 = $$1.getBlockState($$3);
        BlockEntity blockEntity = $$1.getBlockEntity($$3);
        if (blockEntity instanceof Spawner) {
            Spawner $$6 = (Spawner)((Object)blockEntity);
            EntityType<?> $$7 = this.getType($$2);
            $$6.setEntityId($$7, $$1.getRandom());
            $$1.sendBlockUpdated($$3, $$5, $$5, 3);
            $$1.gameEvent((Entity)$$0.getPlayer(), GameEvent.BLOCK_CHANGE, $$3);
            $$2.shrink(1);
            return InteractionResult.CONSUME;
        }
        if ($$5.getCollisionShape($$1, $$3).isEmpty()) {
            BlockPos $$8 = $$3;
        } else {
            $$9 = $$3.relative($$4);
        }
        EntityType<?> $$10 = this.getType($$2);
        if ($$10.spawn((ServerLevel)$$1, $$2, $$0.getPlayer(), $$9, MobSpawnType.SPAWN_EGG, true, !Objects.equals($$3, $$9) && $$4 == Direction.UP) != null) {
            $$2.shrink(1);
            $$1.gameEvent((Entity)$$0.getPlayer(), GameEvent.ENTITY_PLACE, $$3);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        ItemStack $$3 = $$1.getItemInHand($$2);
        BlockHitResult $$4 = SpawnEggItem.getPlayerPOVHitResult($$0, $$1, ClipContext.Fluid.SOURCE_ONLY);
        if ($$4.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass($$3);
        }
        if (!($$0 instanceof ServerLevel)) {
            return InteractionResultHolder.success($$3);
        }
        BlockHitResult $$5 = $$4;
        BlockPos $$6 = $$5.getBlockPos();
        if (!($$0.getBlockState($$6).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass($$3);
        }
        if (!$$0.mayInteract($$1, $$6) || !$$1.mayUseItemAt($$6, $$5.getDirection(), $$3)) {
            return InteractionResultHolder.fail($$3);
        }
        EntityType<?> $$7 = this.getType($$3);
        Object $$8 = $$7.spawn((ServerLevel)$$0, $$3, $$1, $$6, MobSpawnType.SPAWN_EGG, false, false);
        if ($$8 == null) {
            return InteractionResultHolder.pass($$3);
        }
        $$3.consume(1, $$1);
        $$1.awardStat(Stats.ITEM_USED.get(this));
        $$0.gameEvent((Entity)$$1, GameEvent.ENTITY_PLACE, ((Entity)$$8).position());
        return InteractionResultHolder.consume($$3);
    }

    public boolean spawnsEntity(ItemStack $$0, EntityType<?> $$1) {
        return Objects.equals(this.getType($$0), $$1);
    }

    public int getColor(int $$0) {
        return $$0 == 0 ? this.backgroundColor : this.highlightColor;
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable EntityType<?> $$0) {
        return BY_ID.get($$0);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityType<?> getType(ItemStack $$0) {
        CustomData $$1 = $$0.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!$$1.isEmpty()) {
            return $$1.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.defaultType);
        }
        return this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player $$0, Mob $$1, EntityType<? extends Mob> $$2, ServerLevel $$3, Vec3 $$4, ItemStack $$5) {
        Mob $$7;
        if (!this.spawnsEntity($$5, $$2)) {
            return Optional.empty();
        }
        if ($$1 instanceof AgeableMob) {
            AgeableMob $$6 = ((AgeableMob)$$1).getBreedOffspring($$3, (AgeableMob)$$1);
        } else {
            $$7 = $$2.create($$3);
        }
        if ($$7 == null) {
            return Optional.empty();
        }
        $$7.setBaby(true);
        if (!$$7.isBaby()) {
            return Optional.empty();
        }
        $$7.moveTo($$4.x(), $$4.y(), $$4.z(), 0.0f, 0.0f);
        $$3.addFreshEntityWithPassengers($$7);
        $$7.setCustomName($$5.get(DataComponents.CUSTOM_NAME));
        $$5.consume(1, $$0);
        return Optional.of($$7);
    }
}

